/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.util.FileResourceFinder;
import edu.ucla.sspace.util.ResourceFinder;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TokenFilter {
    private final Set<String> tokens;
    private final boolean excludeTokens;
    private TokenFilter parent;

    public TokenFilter(Set<String> set) {
        this(set, false, null);
    }

    public TokenFilter(Set<String> set, boolean bl) {
        this(set, bl, null);
    }

    public TokenFilter(Set<String> set, boolean bl, TokenFilter tokenFilter) {
        this.tokens = set;
        this.excludeTokens = bl;
        this.parent = tokenFilter;
    }

    public boolean accept(String string) {
        return (this.parent == null || this.parent.accept(string)) && this.tokens.contains(string) ^ this.excludeTokens;
    }

    public TokenFilter combine(TokenFilter tokenFilter) {
        TokenFilter tokenFilter2 = tokenFilter;
        this.parent = tokenFilter;
        return tokenFilter2;
    }

    public static TokenFilter loadFromSpecification(String string) {
        return TokenFilter.loadFromSpecification(string, new FileResourceFinder());
    }

    public static TokenFilter loadFromSpecification(String string, ResourceFinder resourceFinder) {
        String[] stringArray;
        TokenFilter tokenFilter = null;
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Invalid number of filter parameters: " + string2);
            }
            String string3 = stringArray2[0];
            boolean bl = string3.equals("exclude");
            if (!bl && !string3.equals("include")) {
                throw new IllegalArgumentException("Invalid filter behavior: " + string3);
            }
            String[] stringArray3 = stringArray2[1].split(":");
            HashSet<String> hashSet = new HashSet<String>();
            try {
                for (String string4 : stringArray3) {
                    BufferedReader bufferedReader = resourceFinder.open(string4);
                    String string5 = null;
                    while ((string5 = bufferedReader.readLine()) != null) {
                        hashSet.add(string5);
                    }
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            tokenFilter = new TokenFilter(hashSet, bl, tokenFilter);
        }
        return tokenFilter;
    }
}

