/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.Document;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class LimitedOneLinePerDocumentIterator
implements Iterator<Document> {
    private final Iterator<Document> iter;
    private final AtomicInteger docCount;
    private boolean isReset;
    private final int docLimit;
    private final boolean useMultipleResets;

    public LimitedOneLinePerDocumentIterator(Iterator<Document> iterator, int n, boolean bl) throws IOException {
        this.iter = iterator;
        this.docLimit = n;
        this.useMultipleResets = bl;
        this.docCount = new AtomicInteger();
        this.isReset = false;
    }

    @Override
    public synchronized boolean hasNext() {
        return this.docCount.get() < this.docLimit && this.iter.hasNext();
    }

    @Override
    public synchronized Document next() {
        if (!this.isReset || this.useMultipleResets) {
            this.docCount.incrementAndGet();
        }
        return this.iter.next();
    }

    public synchronized void reset() {
        this.docCount.set(0);
        this.isReset = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("removing documents is not supported");
    }
}

