/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.text;

import edu.ucla.sspace.text.CorpusReader;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.text.DocumentPreprocessor;
import edu.ucla.sspace.util.DirectoryWalker;
import java.io.File;
import java.io.Reader;
import java.util.Iterator;

public abstract class DirectoryCorpusReader<D extends Document>
implements CorpusReader<D> {
    private final DocumentPreprocessor processor;

    public DirectoryCorpusReader() {
        this(null);
    }

    public DirectoryCorpusReader(DocumentPreprocessor documentPreprocessor) {
        this.processor = documentPreprocessor;
    }

    @Override
    public Iterator<D> read(File file) {
        return this.corpusIterator(new DirectoryWalker(file).iterator());
    }

    @Override
    public Iterator<D> read(Reader reader) {
        throw new UnsupportedOperationException("The DirectoryCorpusReader cannot convert a reader to a directory structur.");
    }

    protected abstract Iterator<D> corpusIterator(Iterator<File> var1);

    public void initialize(Reader reader) {
        throw new UnsupportedOperationException("Cannot form a DirectoryCorpusReader from a Reader instance");
    }

    public abstract class BaseFileIterator
    implements Iterator<D> {
        private Iterator<File> filesToExplore;
        private D nextDoc;

        public BaseFileIterator(Iterator<File> iterator) {
            this.filesToExplore = iterator;
            this.nextDoc = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextDoc != null;
        }

        @Override
        public D next() {
            Object d = this.nextDoc;
            this.nextDoc = this.advance();
            return d;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not permitted.");
        }

        protected abstract D advanceInDoc();

        protected abstract void setupCurrentDoc(File var1);

        protected String cleanDoc(String string) {
            return DirectoryCorpusReader.this.processor != null ? DirectoryCorpusReader.this.processor.process(string) : string;
        }

        protected D advance() {
            Object d = this.advanceInDoc();
            if (d == null) {
                if (!this.filesToExplore.hasNext()) {
                    return null;
                }
                this.setupCurrentDoc(this.filesToExplore.next());
                return this.advance();
            }
            return d;
        }
    }
}

