/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.temporal;

import edu.ucla.sspace.temporal.FileBasedTemporalSemanticSpace;
import edu.ucla.sspace.temporal.TemporalSemanticSpace;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorIO;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TemporalSemanticSpaceUtils {
    private static final Logger LOGGER = Logger.getLogger(TemporalSemanticSpaceUtils.class.getName());

    private TemporalSemanticSpaceUtils() {
    }

    public static TemporalSemanticSpace loadTemporalSemanticSpace(String string) {
        return TemporalSemanticSpaceUtils.loadTemporalSemanticSpace(new File(string), TSSpaceFormat.TEXT);
    }

    public static TemporalSemanticSpace loadTemporalSemanticSpace(File file) {
        return TemporalSemanticSpaceUtils.loadTemporalSemanticSpace(file, TSSpaceFormat.TEXT);
    }

    public static TemporalSemanticSpace loadTemporalSemanticSpace(File file, TSSpaceFormat tSSpaceFormat) {
        return new FileBasedTemporalSemanticSpace(file, tSSpaceFormat);
    }

    public static void printTemporalSemanticSpace(TemporalSemanticSpace temporalSemanticSpace, String string) throws IOException {
        TemporalSemanticSpaceUtils.printTemporalSemanticSpace(temporalSemanticSpace, new File(string), TSSpaceFormat.TEXT);
    }

    public static void printTemporalSemanticSpace(TemporalSemanticSpace temporalSemanticSpace, File file) throws IOException {
        TemporalSemanticSpaceUtils.printTemporalSemanticSpace(temporalSemanticSpace, file, TSSpaceFormat.TEXT);
    }

    public static void printTemporalSemanticSpace(TemporalSemanticSpace temporalSemanticSpace, File file, TSSpaceFormat tSSpaceFormat) throws IOException {
        switch (tSSpaceFormat) {
            case TEXT: {
                TemporalSemanticSpaceUtils.printText(temporalSemanticSpace, file);
                break;
            }
            case SPARSE_TEXT: {
                TemporalSemanticSpaceUtils.printSparseText(temporalSemanticSpace, file);
                break;
            }
            case BINARY: {
                TemporalSemanticSpaceUtils.printBinary(temporalSemanticSpace, file);
                break;
            }
            case SPARSE_BINARY: {
                TemporalSemanticSpaceUtils.printSparseBinary(temporalSemanticSpace, file);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format type: " + (Object)((Object)tSSpaceFormat));
            }
        }
    }

    private static void printText(TemporalSemanticSpace temporalSemanticSpace, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        Set<String> set = temporalSemanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = temporalSemanticSpace.getVectorLength();
        }
        int n2 = set.size();
        printWriter.println(n2 + " " + n);
        int n3 = 0;
        for (String string : set) {
            printWriter.print(string + "|");
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("serializing text %d/%d: %s", n3++, n2, string));
            }
            Iterator iterator = temporalSemanticSpace.getTimeSteps(string).iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                Vector vector = temporalSemanticSpace.getVectorBetween(string, l, l + 1L);
                if (vector == null) continue;
                printWriter.print(l + " " + VectorIO.toString(vector) + "|");
            }
            printWriter.println("");
        }
        printWriter.close();
    }

    private static void printSparseText(TemporalSemanticSpace temporalSemanticSpace, File file) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        Set<String> set = temporalSemanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = temporalSemanticSpace.getVectorLength();
        }
        int n2 = set.size();
        printWriter.println(n2 + " " + n);
        int n3 = 0;
        for (String string : set) {
            printWriter.print(string + "|");
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("serializing sparse text %d/%d: %s", n3++, n2, string));
            }
            SortedSet<Long> sortedSet = temporalSemanticSpace.getTimeSteps(string);
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                Vector vector = temporalSemanticSpace.getVectorBetween(string, l, l + 1L);
                if (vector == null) continue;
                int n4 = 0;
                for (int i = 0; i < vector.length(); ++i) {
                    if (vector.getValue(i).doubleValue() == 0.0) continue;
                    ++n4;
                }
                printWriter.print(l + " " + n4 + "%");
                StringBuilder stringBuilder = new StringBuilder(n4 * 4);
                for (int i = 0; i < vector.length(); ++i) {
                    double d = vector.getValue(i).doubleValue();
                    if (d != 0.0) {
                        stringBuilder.append(i).append(",").append(d);
                    }
                    if (i + 1 >= vector.length()) continue;
                    stringBuilder.append(",");
                }
                printWriter.print(stringBuilder.toString() + "|");
            }
            printWriter.println("");
        }
        printWriter.close();
    }

    private static void printBinary(TemporalSemanticSpace temporalSemanticSpace, File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        Set<String> set = temporalSemanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = temporalSemanticSpace.getVectorLength();
        }
        int n2 = set.size();
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n);
        int n3 = 0;
        for (String string : set) {
            dataOutputStream.writeUTF(string);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("serializing binary %d/%d: %s", n3++, n2, string));
            }
            Iterator iterator = temporalSemanticSpace.getTimeSteps(string).iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                Vector vector = temporalSemanticSpace.getVectorBetween(string, l, l + 1L);
                if (vector == null) continue;
                dataOutputStream.writeLong(l);
                for (int i = 0; i < vector.length(); ++i) {
                    dataOutputStream.writeDouble(vector.getValue(i).doubleValue());
                }
            }
        }
        dataOutputStream.close();
    }

    private static void printSparseBinary(TemporalSemanticSpace temporalSemanticSpace, File file) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
        Set<String> set = temporalSemanticSpace.getWords();
        int n = 0;
        if (set.size() > 0) {
            n = temporalSemanticSpace.getVectorLength();
        }
        int n2 = set.size();
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n);
        int n3 = 0;
        for (String string : set) {
            dataOutputStream.writeUTF(string);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(String.format("serializing sparse binary %d/%d: %s", n3++, n2, string));
            }
            SortedSet<Long> sortedSet = temporalSemanticSpace.getTimeSteps(string);
            dataOutputStream.writeInt(sortedSet.size());
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                int n4;
                long l = (Long)iterator.next();
                Vector vector = temporalSemanticSpace.getVectorBetween(string, l, l + 1L);
                if (vector == null) continue;
                int n5 = 0;
                for (n4 = 0; n4 < vector.length(); ++n4) {
                    if (vector.getValue(n4).doubleValue() == 0.0) continue;
                    ++n5;
                }
                dataOutputStream.writeLong(l);
                dataOutputStream.writeInt(n5);
                for (n4 = 0; n4 < vector.length(); ++n4) {
                    double d = vector.getValue(n4).doubleValue();
                    if (d == 0.0) continue;
                    dataOutputStream.writeInt(n4);
                    dataOutputStream.writeDouble(d);
                }
            }
        }
        dataOutputStream.close();
    }

    public static enum TSSpaceFormat {
        TEXT,
        BINARY,
        SPARSE_TEXT,
        SPARSE_BINARY;

    }
}

