/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.svs;

import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.dependency.DependencyExtractor;
import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dependency.DependencyRelation;
import edu.ucla.sspace.dependency.DependencyTreeNode;
import edu.ucla.sspace.dependency.FilteredDependencyIterator;
import edu.ucla.sspace.svs.VectorCombinor;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledSparseDoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class StructuredVectorSpace
implements SemanticSpace,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SSPACE_NAME = "structured-vector-space";
    public static final String EMPTY_STRING = "";
    private static final Logger LOG = Logger.getLogger(StructuredVectorSpace.class.getName());
    private final StringBasisMapping termBasis;
    private final Map<String, SelectionalPreference> preferenceVectors;
    private final VectorCombinor combinor;
    private transient Map<RelationTuple, SparseDoubleVector> relationVectors;
    private final transient DependencyExtractor parser;
    private final transient DependencyPathAcceptor acceptor;
    private final transient Set<String> semanticFilter;

    public StructuredVectorSpace(DependencyExtractor dependencyExtractor, DependencyPathAcceptor dependencyPathAcceptor, VectorCombinor vectorCombinor) {
        this(dependencyExtractor, dependencyPathAcceptor, vectorCombinor, new StringBasisMapping(), new HashSet<String>());
    }

    public StructuredVectorSpace(DependencyExtractor dependencyExtractor, DependencyPathAcceptor dependencyPathAcceptor, VectorCombinor vectorCombinor, StringBasisMapping stringBasisMapping, Set<String> set) {
        this.parser = dependencyExtractor;
        this.acceptor = dependencyPathAcceptor;
        this.combinor = vectorCombinor;
        this.termBasis = stringBasisMapping;
        this.semanticFilter = set;
        this.preferenceVectors = new ConcurrentHashMap<String, SelectionalPreference>();
        this.relationVectors = new ConcurrentHashMap<RelationTuple, SparseDoubleVector>();
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.preferenceVectors.keySet());
    }

    @Override
    public Vector getVector(String string) {
        SelectionalPreference selectionalPreference = this.preferenceVectors.get(string);
        return selectionalPreference == null ? null : selectionalPreference.lemmaVector;
    }

    @Override
    public String getSpaceName() {
        return SSPACE_NAME;
    }

    @Override
    public int getVectorLength() {
        return this.termBasis.numDimensions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        Object object;
        Object object2;
        HashMap<Pair<String>, Double> hashMap = new HashMap<Pair<String>, Double>();
        HashMap<RelationTuple, SparseDoubleVector> hashMap2 = new HashMap<RelationTuple, SparseDoubleVector>();
        Object object3 = null;
        while ((object3 = this.parser.readNextTree(bufferedReader)) != null) {
            if (((DependencyTreeNode[])object3).length == 0) continue;
            for (int i = 0; i < ((DependencyTreeNode[])object3).length; ++i) {
                if (!object3[i].pos().startsWith("N") && !object3[i].pos().startsWith("J") && !object3[i].pos().startsWith("V") || !this.acceptWord((String)(object2 = object3[i].word()))) continue;
                int n = this.termBasis.getDimension((String)object2);
                object = new FilteredDependencyIterator((DependencyTreeNode)object3[i], this.acceptor, 1);
                while (object.hasNext()) {
                    Pair<String> pair;
                    String string;
                    DependencyPath dependencyPath = (DependencyPath)object.next();
                    DependencyTreeNode dependencyTreeNode = dependencyPath.last();
                    if (!dependencyTreeNode.pos().startsWith("N") && !dependencyTreeNode.pos().startsWith("J") && !dependencyTreeNode.pos().startsWith("V") || (string = dependencyTreeNode.word()).equals(EMPTY_STRING)) continue;
                    int n2 = this.termBasis.getDimension(string);
                    Double d = (Double)hashMap.get(pair = new Pair<String>((String)object2, string));
                    hashMap.put(pair, d == null ? 1.0 : 1.0 + d);
                    DependencyRelation dependencyRelation = dependencyPath.iterator().next();
                    if (!dependencyRelation.headNode().word().equals(object2)) continue;
                    RelationTuple relationTuple = new RelationTuple(n, dependencyRelation.relation().intern());
                    SparseDoubleVector sparseDoubleVector = (SparseDoubleVector)hashMap2.get(relationTuple);
                    if (sparseDoubleVector == null) {
                        sparseDoubleVector = new CompactSparseVector();
                        hashMap2.put(relationTuple, sparseDoubleVector);
                    }
                    sparseDoubleVector.add(n2, 1.0);
                }
            }
        }
        bufferedReader.close();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Pair)entry.getKey();
            SelectionalPreference selectionalPreference = this.preferenceVectors.get(((Pair)object2).x);
            if (selectionalPreference == null) {
                object = this;
                synchronized (object) {
                    selectionalPreference = this.preferenceVectors.get(((Pair)object2).x);
                    if (selectionalPreference == null) {
                        selectionalPreference = new SelectionalPreference();
                        this.preferenceVectors.put((String)((Pair)object2).x, selectionalPreference);
                    }
                }
            }
            object = selectionalPreference;
            synchronized (object) {
                selectionalPreference.lemmaVector.add(this.termBasis.getDimension((String)((Pair)object2).y), (Double)entry.getValue());
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            Object object4;
            object2 = this.relationVectors.get(entry.getKey());
            if (object2 == null) {
                object4 = this;
                synchronized (object4) {
                    object2 = this.relationVectors.get(entry.getKey());
                    if (object2 == null) {
                        object2 = new CompactSparseVector();
                        this.relationVectors.put((RelationTuple)entry.getKey(), (SparseDoubleVector)object2);
                    }
                }
            }
            object4 = object2;
            synchronized (object4) {
                VectorMath.add((DoubleVector)object2, (DoubleVector)entry.getValue());
            }
        }
    }

    @Override
    public void processSpace(Properties properties) {
        CompactSparseVector compactSparseVector = new CompactSparseVector();
        for (Map.Entry<RelationTuple, SparseDoubleVector> entry : this.relationVectors.entrySet()) {
            RelationTuple relationTuple = entry.getKey();
            SparseDoubleVector sparseDoubleVector = entry.getValue();
            String string = (String)this.termBasis.getDimensionDescription(relationTuple.head);
            String string2 = relationTuple.relation;
            SelectionalPreference selectionalPreference = this.preferenceVectors.get(string);
            if (selectionalPreference == null) {
                LOG.fine("what the fuck");
            }
            for (int n : sparseDoubleVector.getNonZeroIndices()) {
                double d = sparseDoubleVector.get(n);
                String string3 = (String)this.termBasis.getDimensionDescription(n);
                SelectionalPreference selectionalPreference2 = this.preferenceVectors.get(string3);
                if (selectionalPreference2 == null) continue;
                selectionalPreference.addPreference(string2, selectionalPreference2.lemmaVector, d);
                selectionalPreference2.addInversePreference(string2, selectionalPreference.lemmaVector, d);
            }
            entry.setValue(compactSparseVector);
        }
        this.relationVectors = null;
    }

    public SparseDoubleVector contextualize(String string, String string2, String string3, boolean bl) {
        SelectionalPreference selectionalPreference = this.preferenceVectors.get(string);
        SelectionalPreference selectionalPreference2 = this.preferenceVectors.get(string3);
        if (selectionalPreference == null) {
            return null;
        }
        if (selectionalPreference2 == null) {
            return selectionalPreference.lemmaVector;
        }
        if (bl) {
            return this.combinor.combineUnmodified(selectionalPreference.lemmaVector, selectionalPreference2.inversePreference(string2));
        }
        return this.combinor.combineUnmodified(selectionalPreference.lemmaVector, selectionalPreference2.preference(string2));
    }

    public void setSemanticFilter(Set<String> set) {
        this.semanticFilter.clear();
        this.semanticFilter.addAll(set);
    }

    private boolean acceptWord(String string) {
        return !string.equals(EMPTY_STRING) && (this.semanticFilter.isEmpty() || this.semanticFilter.contains(string));
    }

    private class SelectionalPreference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public SparseDoubleVector lemmaVector = new CompactSparseVector();
        public Map<String, SparseDoubleVector> selPreferences = new HashMap<String, SparseDoubleVector>();
        public Map<String, SparseDoubleVector> inverseSelPreferences = new HashMap<String, SparseDoubleVector>();

        public void addPreference(String string, SparseDoubleVector sparseDoubleVector, double d) {
            this.add(string, new ScaledSparseDoubleVector(sparseDoubleVector, d), this.selPreferences);
        }

        public void addInversePreference(String string, SparseDoubleVector sparseDoubleVector, double d) {
            this.add(string, new ScaledSparseDoubleVector(sparseDoubleVector, d), this.inverseSelPreferences);
        }

        private void add(String string, SparseDoubleVector sparseDoubleVector, Map<String, SparseDoubleVector> map) {
            SparseDoubleVector sparseDoubleVector2 = map.get(string);
            if (sparseDoubleVector2 == null) {
                map.put(string, (SparseDoubleVector)Vectors.copyOf(sparseDoubleVector));
                return;
            }
            map.put(string, StructuredVectorSpace.this.combinor.combine(sparseDoubleVector2, sparseDoubleVector));
        }

        public SparseDoubleVector preference(String string) {
            return this.selPreferences.get(string);
        }

        public SparseDoubleVector inversePreference(String string) {
            return this.inverseSelPreferences.get(string);
        }
    }

    private class RelationTuple {
        public int head;
        public String relation;

        public RelationTuple(int n, String string) {
            this.head = n;
            this.relation = string;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RelationTuple)) {
                return false;
            }
            RelationTuple relationTuple = (RelationTuple)object;
            return this.head == relationTuple.head && this.relation == relationTuple.relation;
        }

        public int hashCode() {
            return this.head ^ this.relation.hashCode();
        }
    }
}

