/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.rri;

import edu.ucla.sspace.common.Filterable;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.WorkerThread;
import edu.ucla.sspace.vector.CompactSparseIntegerVector;
import edu.ucla.sspace.vector.DenseIntVector;
import edu.ucla.sspace.vector.IntegerVector;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.VectorMath;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class ReflectiveRandomIndexing
implements SemanticSpace,
Filterable {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.ri.ReflectiveRandomIndexing";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.ri.ReflectiveRandomIndexing.vectorLength";
    public static final String USE_SPARSE_SEMANTICS_PROPERTY = "edu.ucla.sspace.ri.ReflectiveRandomIndexing.sparseSemantics";
    public static final int DEFAULT_VECTOR_LENGTH = 4000;
    private static final String RRI_SSPACE_NAME = "reflective-random-indexing";
    private static final Logger LOGGER = Logger.getLogger(ReflectiveRandomIndexing.class.getName());
    private final Map<Integer, IntegerVector> docToVector;
    private final Map<String, IntegerVector> termToReflectiveSemantics;
    private final Map<String, TernaryVector> termToIndexVector;
    private final Map<String, Integer> termToIndex;
    private final AtomicInteger documentCounter;
    private final int vectorLength;
    private final boolean useSparseSemantics;
    private final Set<String> semanticFilter;
    private final RandomIndexVectorGenerator indexVectorGenerator;
    private File compressedDocuments;
    private DataOutputStream compressedDocumentsWriter;
    private int termIndexCounter;
    private String[] indexToTerm;

    public ReflectiveRandomIndexing() {
        this(System.getProperties());
    }

    public ReflectiveRandomIndexing(Properties properties) {
        String string = properties.getProperty(VECTOR_LENGTH_PROPERTY);
        this.vectorLength = string != null ? Integer.parseInt(string) : 4000;
        String string2 = properties.getProperty(USE_SPARSE_SEMANTICS_PROPERTY);
        this.useSparseSemantics = string2 != null ? Boolean.parseBoolean(string2) : true;
        this.indexVectorGenerator = new RandomIndexVectorGenerator(this.vectorLength, properties);
        this.termToIndexVector = new ConcurrentHashMap<String, TernaryVector>();
        this.docToVector = new ConcurrentHashMap<Integer, IntegerVector>();
        this.termToReflectiveSemantics = new ConcurrentHashMap<String, IntegerVector>();
        this.termToIndex = new ConcurrentHashMap<String, Integer>();
        this.documentCounter = new AtomicInteger();
        this.semanticFilter = new HashSet<String>();
        try {
            this.compressedDocuments = File.createTempFile("reflective-ri-documents", ".dat");
            this.compressedDocumentsWriter = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.compressedDocuments)));
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private IntegerVector createVector() {
        return this.useSparseSemantics ? new CompactSparseIntegerVector(this.vectorLength) : new DenseIntVector(this.vectorLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TernaryVector getTermIndexVector(String string) {
        TernaryVector ternaryVector = this.termToIndexVector.get(string);
        if (ternaryVector == null) {
            ReflectiveRandomIndexing reflectiveRandomIndexing = this;
            synchronized (reflectiveRandomIndexing) {
                ternaryVector = this.termToIndexVector.get(string);
                if (ternaryVector == null) {
                    this.termToIndex.put(string, this.termIndexCounter++);
                    this.termToReflectiveSemantics.put(string, this.createVector());
                    ternaryVector = this.indexVectorGenerator.generate();
                    this.termToIndexVector.put(string, ternaryVector);
                }
            }
        }
        return ternaryVector;
    }

    @Override
    public IntegerVector getVector(String string) {
        IntegerVector integerVector = this.termToReflectiveSemantics.get(string);
        if (integerVector == null) {
            return null;
        }
        return Vectors.immutable(integerVector);
    }

    @Override
    public String getSpaceName() {
        return "reflective-random-indexing-" + this.vectorLength + "v";
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToReflectiveSemantics.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        Object object;
        int n = this.documentCounter.getAndIncrement();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n2 = 0;
        int n3 = 0;
        IntegerVector integerVector = this.createVector();
        this.docToVector.put(n, integerVector);
        while (iterator.hasNext()) {
            boolean bl;
            ++n2;
            object = iterator.next();
            boolean bl2 = bl = this.semanticFilter.isEmpty() || this.semanticFilter.contains(object) && !((String)object).equals("");
            if (!bl) continue;
            ++n3;
            ReflectiveRandomIndexing.add(integerVector, this.getTermIndexVector((String)object));
            int n4 = this.termToIndex.get(object);
            dataOutputStream.writeInt(n4);
        }
        bufferedReader.close();
        dataOutputStream.close();
        object = byteArrayOutputStream.toByteArray();
        DataOutputStream dataOutputStream2 = this.compressedDocumentsWriter;
        synchronized (dataOutputStream2) {
            this.compressedDocumentsWriter.writeInt(n3);
            this.compressedDocumentsWriter.write((byte[])object, 0, ((Object)object).length);
        }
    }

    @Override
    public void processSpace(Properties properties) {
        try {
            this.processSpace();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private void processSpace() throws IOException {
        LOGGER.info("generating reflective vectors");
        this.compressedDocumentsWriter.close();
        int n = this.documentCounter.get();
        this.termToIndexVector.clear();
        this.indexToTerm = new String[this.termToIndex.size()];
        for (Map.Entry<String, Integer> object2 : this.termToIndex.entrySet()) {
            this.indexToTerm[object2.getValue().intValue()] = object2.getKey();
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.compressedDocuments)));
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        for (int semaphore = 0; semaphore < Runtime.getRuntime().availableProcessors(); ++semaphore) {
            WorkerThread i = new WorkerThread(linkedBlockingQueue);
            i.start();
        }
        final Semaphore semaphore = new Semaphore(0);
        for (int interruptedException = 0; interruptedException < n; ++interruptedException) {
            final int n2 = interruptedException;
            int n3 = dataInputStream.readInt();
            final int[] nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            linkedBlockingQueue.offer(new Runnable(){

                @Override
                public void run() {
                    LOGGER.fine("reprocessing doc #" + n2);
                    ReflectiveRandomIndexing.this.processIntDocument((IntegerVector)ReflectiveRandomIndexing.this.docToVector.get(n2), nArray);
                    semaphore.release();
                }
            });
        }
        dataInputStream.close();
        try {
            semaphore.acquire(n);
        }
        catch (InterruptedException interruptedException) {
            throw new Error("interrupted while waiting for documents to finish reprocessing", interruptedException);
        }
        LOGGER.fine("finished reprocessing all documents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIntDocument(IntegerVector integerVector, int[] nArray) {
        for (int n : nArray) {
            IntegerVector integerVector2;
            IntegerVector integerVector3 = integerVector2 = this.termToReflectiveSemantics.get(this.indexToTerm[n]);
            synchronized (integerVector3) {
                VectorMath.add(integerVector2, integerVector);
            }
        }
    }

    @Override
    public void setSemanticFilter(Set<String> set) {
        this.semanticFilter.clear();
        this.semanticFilter.addAll(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void add(IntegerVector integerVector, TernaryVector ternaryVector) {
        IntegerVector integerVector2 = integerVector;
        synchronized (integerVector2) {
            for (int n : ternaryVector.positiveDimensions()) {
                integerVector.add(n, 1);
            }
            for (int n : ternaryVector.negativeDimensions()) {
                integerVector.add(n, -1);
            }
        }
    }
}

