/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.nonlinear;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.hal.EvenWeighting;
import edu.ucla.sspace.hal.WeightingFunction;
import edu.ucla.sspace.matrix.AffinityMatrixCreator;
import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.matrix.GrowingSparseMatrix;
import edu.ucla.sspace.matrix.LocalityPreservingProjection;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class LocalityPreservingCooccurrenceSpace
implements SemanticSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace";
    public static final String ENTROPY_THRESHOLD_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.threshold";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.windowSize";
    public static final String WEIGHTING_FUNCTION_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.weighting";
    public static final String LPCS_DIMENSIONS_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.dimensions";
    public static final String LPCS_AFFINITY_EDGE_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeType";
    public static final String LPCS_AFFINITY_EDGE_PARAM_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeTypeParam";
    public static final String LPCS_AFFINITY_EDGE_WEIGHTING_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeWeighting";
    public static final String LPCS_AFFINITY_EDGE_WEIGHTING_PARAM_PROPERTY = "edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeWeightingParam";
    public static final int DEFAULT_WINDOW_SIZE = 5;
    public static final WeightingFunction DEFAULT_WEIGHTING = new EvenWeighting();
    private static final Logger LOGGER = Logger.getLogger(LocalityPreservingCooccurrenceSpace.class.getName());
    private final Map<String, Integer> termToIndex;
    private final int windowSize;
    private final WeightingFunction weighting;
    private int wordIndexCounter = 0;
    private SparseMatrix cooccurrenceMatrix = new GrowingSparseMatrix();
    private AtomicMatrix atomicMatrix = Matrices.synchronizedMatrix(this.cooccurrenceMatrix);
    private Matrix reduced = null;

    public LocalityPreservingCooccurrenceSpace() {
        this(System.getProperties());
    }

    public LocalityPreservingCooccurrenceSpace(Properties properties) {
        this.termToIndex = new ConcurrentHashMap<String, Integer>();
        String string = properties.getProperty(WINDOW_SIZE_PROPERTY);
        this.windowSize = string != null ? Integer.parseInt(string) : 5;
        String string2 = properties.getProperty(WEIGHTING_FUNCTION_PROPERTY);
        this.weighting = string2 == null ? DEFAULT_WEIGHTING : LocalityPreservingCooccurrenceSpace.loadWeightingFunction(string2);
    }

    private static WeightingFunction loadWeightingFunction(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            WeightingFunction weightingFunction = (WeightingFunction)clazz.newInstance();
            return weightingFunction;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        int n;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        String string = null;
        HashMap<Pair<Integer>, Double> hashMap = new HashMap<Pair<Integer>, Double>();
        for (n = 0; n < this.windowSize && iterator.hasNext(); ++n) {
            arrayDeque.offer(iterator.next());
        }
        while (!arrayDeque.isEmpty()) {
            Double d;
            double d2;
            Pair<Integer> pair;
            int n2;
            string = (String)arrayDeque.remove();
            if (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayDeque.offer(string2);
            }
            if (string.equals("")) {
                arrayDeque2.offer(string);
                if (arrayDeque2.size() <= this.windowSize) continue;
                arrayDeque2.remove();
                continue;
            }
            n = this.getIndexFor(string);
            int n3 = 1;
            for (String string3 : arrayDeque) {
                if (!string3.equals("")) {
                    n2 = this.getIndexFor(string3);
                    pair = new Pair<Integer>(n, n2);
                    d2 = this.weighting.weight(n3, this.windowSize);
                    d = (Double)hashMap.get(pair);
                    hashMap.put(pair, d == null ? d2 : d2 + d);
                }
                ++n3;
            }
            n3 = -1;
            for (String string3 : arrayDeque2) {
                if (!string3.equals("")) {
                    n2 = this.getIndexFor(string3);
                    pair = new Pair<Integer>(n2, n);
                    d2 = this.weighting.weight(n3, this.windowSize);
                    d = (Double)hashMap.get(pair);
                    hashMap.put(pair, d == null ? d2 : d2 + d);
                }
                --n3;
            }
            arrayDeque2.offer(string);
            if (arrayDeque2.size() <= this.windowSize) continue;
            arrayDeque2.remove();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Iterator iterator2 = (Pair)entry.getKey();
            this.atomicMatrix.addAndGet((Integer)((Pair)((Object)iterator2)).x, (Integer)((Pair)((Object)iterator2)).y, (Double)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getIndexFor(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            LocalityPreservingCooccurrenceSpace localityPreservingCooccurrenceSpace = this;
            synchronized (localityPreservingCooccurrenceSpace) {
                n = this.termToIndex.get(string);
                if (n == null) {
                    int n2 = this.wordIndexCounter++;
                    this.termToIndex.put(string, n2);
                    return n2;
                }
            }
        }
        return n;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToIndex.keySet());
    }

    @Override
    public Vector getVector(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            return null;
        }
        return this.reduced.getRowVector(n);
    }

    @Override
    public int getVectorLength() {
        return this.reduced.columns();
    }

    @Override
    public void processSpace(Properties properties) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        int n = 300;
        AffinityMatrixCreator.EdgeType edgeType = AffinityMatrixCreator.EdgeType.NEAREST_NEIGHBORS;
        double d = 20.0;
        AffinityMatrixCreator.EdgeWeighting edgeWeighting = AffinityMatrixCreator.EdgeWeighting.COSINE_SIMILARITY;
        double d2 = 0.0;
        String string5 = properties.getProperty(LPCS_DIMENSIONS_PROPERTY);
        if (string5 != null) {
            try {
                n = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.dimensions is not an integer: " + string5);
            }
        }
        if ((string4 = properties.getProperty(LPCS_AFFINITY_EDGE_PROPERTY)) != null) {
            edgeType = AffinityMatrixCreator.EdgeType.valueOf(string4.toUpperCase());
        }
        if ((string3 = properties.getProperty(LPCS_AFFINITY_EDGE_PARAM_PROPERTY)) != null) {
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeTypeParam is not an double: " + string3);
            }
        }
        if ((string2 = properties.getProperty(LPCS_AFFINITY_EDGE_WEIGHTING_PROPERTY)) != null) {
            edgeWeighting = AffinityMatrixCreator.EdgeWeighting.valueOf(string2.toUpperCase());
        }
        if ((string = properties.getProperty(LPCS_AFFINITY_EDGE_WEIGHTING_PARAM_PROPERTY)) != null) {
            try {
                d2 = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.lpsa.LocalityPreservingCooccurrenceSpace.affinityEdgeWeightingParam is not an double: " + string);
            }
        }
        try {
            LOGGER.info("reducing to " + n + " dimensions");
            object = new File("lpcs-term-index." + Math.random() + ".map");
            PrintWriter printWriter = new PrintWriter((File)object);
            for (Map.Entry<String, Integer> entry : this.termToIndex.entrySet()) {
                printWriter.println(entry.getKey() + "\t" + entry.getValue());
            }
            printWriter.close();
            LOGGER.info("wrote term-index map to " + object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        object = AffinityMatrixCreator.calculate(this.cooccurrenceMatrix, Similarity.SimType.COSINE, edgeType, d, edgeWeighting, d2);
        this.reduced = LocalityPreservingProjection.project((Matrix)this.cooccurrenceMatrix, (MatrixFile)object, n);
    }

    @Override
    public String getSpaceName() {
        return "nws-semantic-space";
    }
}

