/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DoubleVector;

public class TransposedMatrix
implements Matrix {
    final Matrix m;

    public TransposedMatrix(Matrix matrix) {
        this.m = matrix;
    }

    @Override
    public int columns() {
        return this.m.rows();
    }

    @Override
    public double get(int n, int n2) {
        return this.m.get(n2, n);
    }

    @Override
    public double[] getColumn(int n) {
        return this.m.getRow(n);
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        return this.m.getRowVector(n);
    }

    @Override
    public double[] getRow(int n) {
        return this.m.getColumn(n);
    }

    @Override
    public DoubleVector getRowVector(int n) {
        return this.m.getColumnVector(n);
    }

    @Override
    public int rows() {
        return this.m.columns();
    }

    @Override
    public void set(int n, int n2, double d) {
        this.m.set(n2, n, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.m.setRow(n, dArray);
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.m.setRow(n, doubleVector);
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.m.setColumn(n, dArray);
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.m.setColumn(n, doubleVector);
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.columns()][0];
        int n = this.columns();
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.m.getRow(i);
        }
        return dArray;
    }
}

