/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.IntegerMap;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class TransformStatistics {
    public static MatrixStatistics extractStatistics(Matrix matrix) {
        return TransformStatistics.extractStatistics(matrix, false, false);
    }

    public static MatrixStatistics extractStatistics(Matrix matrix, boolean bl, boolean bl2) {
        double[] dArray = new double[matrix.rows()];
        double[] dArray2 = new double[matrix.columns()];
        double d = 0.0;
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            for (int i = 0; i < matrix.rows(); ++i) {
                int[] nArray;
                SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                for (int n : nArray = sparseDoubleVector.getNonZeroIndices()) {
                    double d2 = sparseDoubleVector.get(n);
                    int n2 = i;
                    dArray[n2] = dArray[n2] + (bl ? 1.0 : d2);
                    int n3 = n;
                    dArray2[n3] = dArray2[n3] + (bl2 ? 1.0 : d2);
                    d += d2;
                }
            }
        } else {
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    double d3 = matrix.get(i, j);
                    int n = i;
                    dArray[n] = dArray[n] + (bl ? 1.0 : d3);
                    int n4 = j;
                    dArray2[n4] = dArray2[n4] + (bl2 ? 1.0 : d3);
                    d += d3;
                }
            }
        }
        return new MatrixStatistics(dArray, dArray2, d);
    }

    public static MatrixStatistics extractStatistics(File file, MatrixIO.Format format) {
        return TransformStatistics.extractStatistics(file, format, false, false);
    }

    public static MatrixStatistics extractStatistics(File file, MatrixIO.Format format, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        Iterator<MatrixEntry> iterator;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        IntegerMap<Double> integerMap = new IntegerMap<Double>();
        IntegerMap<Double> integerMap2 = new IntegerMap<Double>();
        try {
            iterator = MatrixIO.getMatrixFileIterator(file, format);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2.column() >= n) {
                n = object2.column() + 1;
            }
            if (object2.row() >= n2) {
                n2 = object2.row() + 1;
            }
            if (object2.value() == 0.0) continue;
            object = (Double)integerMap.get((Object)object2.row());
            double d2 = bl ? 1.0 : object2.value();
            integerMap.put(object2.row(), Double.valueOf(object == null ? d2 : (Double)object + d2));
            object = (Double)integerMap2.get((Object)object2.column());
            double d3 = bl2 ? 1.0 : object2.value();
            integerMap2.put(object2.column(), Double.valueOf(object == null ? d3 : (Double)object + d3));
            d += object2.value();
        }
        object2 = TransformStatistics.extractValues(integerMap, n2);
        object = TransformStatistics.extractValues(integerMap2, n);
        return new MatrixStatistics((double[])object2, (double[])object, d);
    }

    private static <T extends Number> double[] extractValues(Map<Integer, T> map, int n) {
        double[] dArray = new double[n];
        for (Map.Entry<Integer, T> entry : map.entrySet()) {
            if (entry.getKey() > dArray.length) {
                throw new IllegalArgumentException("Array size is too small for values in the given map");
            }
            dArray[entry.getKey().intValue()] = ((Number)entry.getValue()).doubleValue();
        }
        return dArray;
    }

    public static class MatrixStatistics {
        public double[] rowSums;
        public double[] columnSums;
        public double matrixSum;

        public MatrixStatistics(double[] dArray, double[] dArray2, double d) {
            this.rowSums = dArray;
            this.columnSums = dArray2;
            this.matrixSum = d;
        }
    }
}

