/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.TransformStatistics;
import java.io.File;

public class TfIdfDocStripedTransform
extends BaseTransform {
    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new TfIdfGlobalTransform(matrix);
    }

    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new TfIdfGlobalTransform(file, format);
    }

    public String toString() {
        return "TF-IDF-DOC-STRIPED";
    }

    public class TfIdfGlobalTransform
    implements GlobalTransform {
        private double[] docTermCount;
        private double[] termDocCount;
        private int totalDocCount;

        public TfIdfGlobalTransform(Matrix matrix) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(matrix, false, true);
            this.docTermCount = matrixStatistics.rowSums;
            this.termDocCount = matrixStatistics.columnSums;
            this.totalDocCount = this.docTermCount.length;
        }

        public TfIdfGlobalTransform(File file, MatrixIO.Format format) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(file, format, false, true);
            this.docTermCount = matrixStatistics.rowSums;
            this.termDocCount = matrixStatistics.columnSums;
            this.totalDocCount = this.docTermCount.length;
        }

        @Override
        public double transform(int n, int n2, double d) {
            double d2 = d / this.docTermCount[n];
            double d3 = Math.log((double)this.totalDocCount / (1.0 + this.termDocCount[n2]));
            return d2 * d3;
        }
    }
}

