/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;

public class SynchronizedSparseMatrix
implements SparseMatrix,
AtomicMatrix {
    private final SparseMatrix m;

    public SynchronizedSparseMatrix(SparseMatrix sparseMatrix) {
        this.m = sparseMatrix;
    }

    @Override
    public synchronized double addAndGet(int n, int n2, double d) {
        double d2 = this.m.get(n, n2) + d;
        this.m.set(n, n2, d2);
        return d2;
    }

    @Override
    public synchronized double getAndAdd(int n, int n2, double d) {
        double d2 = this.m.get(n, n2);
        this.m.set(n, n2, d2 + d);
        return d2;
    }

    @Override
    public synchronized int columns() {
        return this.m.columns();
    }

    @Override
    public synchronized double get(int n, int n2) {
        return this.m.get(n, n2);
    }

    @Override
    public synchronized double[] getColumn(int n) {
        return this.m.getColumn(n);
    }

    @Override
    public synchronized SparseDoubleVector getColumnVector(int n) {
        return this.m.getColumnVector(n);
    }

    @Override
    public synchronized double[] getRow(int n) {
        return this.m.getRow(n);
    }

    @Override
    public synchronized SparseDoubleVector getRowVector(int n) {
        return this.m.getRowVector(n);
    }

    @Override
    public synchronized int rows() {
        return this.m.rows();
    }

    @Override
    public synchronized void set(int n, int n2, double d) {
        this.m.set(n, n2, d);
    }

    @Override
    public synchronized void setColumn(int n, double[] dArray) {
        this.m.setColumn(n, dArray);
    }

    @Override
    public synchronized void setColumn(int n, DoubleVector doubleVector) {
        this.m.setColumn(n, doubleVector);
    }

    @Override
    public synchronized void setRow(int n, double[] dArray) {
        this.m.setRow(n, dArray);
    }

    @Override
    public synchronized void setRow(int n, DoubleVector doubleVector) {
        this.m.setRow(n, doubleVector);
    }

    @Override
    public synchronized double[][] toDenseArray() {
        return this.m.toDenseArray();
    }
}

