/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import ch.akuhn.edu.mit.tedlab.SMat;
import ch.akuhn.edu.mit.tedlab.SVDRec;
import ch.akuhn.edu.mit.tedlab.Svdlib;
import edu.ucla.sspace.matrix.ArrayMatrix;
import edu.ucla.sspace.matrix.DiagonalMatrix;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.MatrixIOException;
import edu.ucla.sspace.matrix.SparseMatrix;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class SvdlibjDriver {
    private SvdlibjDriver() {
    }

    public static Matrix[] svd(Matrix matrix, int n) {
        SMat sMat = SvdlibjDriver.covertToSMat(matrix);
        return SvdlibjDriver.svd(sMat, n);
    }

    public static Matrix[] svd(File file, MatrixIO.Format format, int n) throws IOException {
        File file2 = MatrixIO.convertFormat(file, format, MatrixIO.Format.SVDLIBC_SPARSE_BINARY);
        SMat sMat = SvdlibjDriver.readToSMat(file2);
        return SvdlibjDriver.svd(sMat, n);
    }

    static Matrix[] svd(SMat sMat, int n) {
        SVDRec sVDRec = new Svdlib().svdLAS2A(sMat, n);
        int n2 = sVDRec.Ut.cols;
        int n3 = sVDRec.Ut.rows;
        ArrayMatrix arrayMatrix = new ArrayMatrix(n2, n3);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                arrayMatrix.set(j, i, sVDRec.Ut.value[i][j]);
            }
        }
        sVDRec.Ut = null;
        DiagonalMatrix diagonalMatrix = new DiagonalMatrix(sVDRec.S);
        sVDRec.S = null;
        n3 = sVDRec.Vt.rows;
        n2 = sVDRec.Vt.cols;
        ArrayMatrix arrayMatrix2 = new ArrayMatrix(sVDRec.Vt.rows, sVDRec.Vt.cols);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                arrayMatrix2.set(i, j, sVDRec.Vt.value[i][j]);
            }
        }
        sVDRec.Vt = null;
        return new Matrix[]{arrayMatrix, diagonalMatrix, arrayMatrix2};
    }

    static File writeToFile(SMat sMat) throws IOException {
        File file = File.createTempFile("svdlibj-output", ".mat");
        file.deleteOnExit();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        dataOutputStream.writeInt(sMat.rows);
        dataOutputStream.writeInt(sMat.cols);
        dataOutputStream.writeInt(sMat.vals);
        boolean bl = false;
        for (int i = 0; i < sMat.cols; ++i) {
            int n = sMat.pointr[i];
            int n2 = sMat.pointr[i + 1] - sMat.pointr[i];
            dataOutputStream.writeInt(n2);
            for (int j = 0; j < n + n2; ++j) {
                int n3 = sMat.rowind[j];
                double d = sMat.value[j];
                dataOutputStream.writeInt(n3);
                dataOutputStream.writeFloat((float)d);
            }
        }
        dataOutputStream.close();
        return file;
    }

    static SMat covertToSMat(Matrix matrix) {
        SMat sMat = null;
        if (matrix instanceof SparseMatrix) {
            int n;
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            int n2 = matrix.rows();
            int n3 = matrix.columns();
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                n4 += sparseMatrix.getRowVector(n).getNonZeroIndices().length;
            }
            sMat = new SMat(n2, n3, n4);
            n4 = 0;
            for (n = 0; n < n3; ++n) {
                sMat.pointr[n] = n4;
                for (int i = 0; i < n2; ++i) {
                    double d = matrix.get(i, n);
                    if (d == 0.0) continue;
                    sMat.rowind[n4] = i;
                    sMat.value[n4] = d;
                    ++n4;
                }
            }
            sMat.pointr[n3] = sMat.vals;
        } else {
            int n = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = matrix.rows();
            int n8 = matrix.columns();
            for (n = 0; n < n7; ++n) {
                for (n5 = 0; n5 < n8; ++n5) {
                    if (matrix.get(n, n5) == 0.0) continue;
                    ++n6;
                }
            }
            sMat = new SMat(n7, n8, n6);
            n6 = 0;
            for (n5 = 0; n5 < n8; ++n5) {
                sMat.pointr[n5] = n6;
                for (n = 0; n < n7; ++n) {
                    double d = matrix.get(n, n5);
                    if (d == 0.0) continue;
                    sMat.rowind[n6] = n;
                    sMat.value[n6] = d;
                    ++n6;
                }
            }
            sMat.pointr[n8] = sMat.vals;
        }
        return sMat;
    }

    static SMat readToSMat(File file) throws IOException {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            SMat sMat = new SMat(n, n2, n3);
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                sMat.pointr[i] = n4;
                int n5 = dataInputStream.readInt();
                for (int j = 0; j < n5; ++j) {
                    int n6 = dataInputStream.readInt();
                    float f = dataInputStream.readFloat();
                    sMat.rowind[n4] = n6;
                    sMat.value[n4] = f;
                    ++n4;
                }
            }
            sMat.pointr[n2] = n3;
            return sMat;
        }
        catch (EOFException eOFException) {
            throw new MatrixIOException("Truncated matrix data file: " + file);
        }
    }
}

