/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SvdlibcSparseBinaryMatrixBuilder
implements MatrixBuilder {
    private static final Logger LOGGER = Logger.getLogger(SvdlibcSparseBinaryMatrixBuilder.class.getName());
    private final DataOutputStream matrixDos;
    private final boolean transposeData;
    private boolean isFinished;
    private int curCol;
    private File matrixFile;
    private int numRows;
    private int nonZeroValues;
    private File transposedMatrixFile;

    public SvdlibcSparseBinaryMatrixBuilder() {
        this(SvdlibcSparseBinaryMatrixBuilder.getTempMatrixFile(), false);
    }

    public SvdlibcSparseBinaryMatrixBuilder(boolean bl) {
        this(SvdlibcSparseBinaryMatrixBuilder.getTempMatrixFile(), bl);
    }

    public SvdlibcSparseBinaryMatrixBuilder(File file) {
        this(file, false);
    }

    public SvdlibcSparseBinaryMatrixBuilder(File file, boolean bl) {
        this.matrixFile = file;
        this.transposeData = bl;
        this.curCol = 0;
        this.numRows = 0;
        this.nonZeroValues = 0;
        this.isFinished = false;
        try {
            File file2 = bl ? (this.transposedMatrixFile = SvdlibcSparseBinaryMatrixBuilder.getTempMatrixFile()) : file;
            this.matrixDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
            for (int i = 0; i < 3; ++i) {
                this.matrixDos.writeInt(0);
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static File getTempMatrixFile() {
        File file = null;
        try {
            file = File.createTempFile("svdlibc-sparse-binary-matrix", ".dat");
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return file;
    }

    @Override
    public synchronized int addColumn(double[] dArray) {
        int n;
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (dArray.length > this.numRows) {
            this.numRows = dArray.length;
        }
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == 0.0) continue;
            ++n2;
        }
        this.nonZeroValues += n2;
        try {
            this.matrixDos.writeInt(n2);
            for (n = 0; n < dArray.length; ++n) {
                if (dArray[n] == 0.0) continue;
                this.matrixDos.writeInt(n);
                this.matrixDos.writeFloat((float)dArray[n]);
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return ++this.curCol;
    }

    @Override
    public synchronized int addColumn(SparseArray<? extends Number> sparseArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (sparseArray.length() > this.numRows) {
            this.numRows = sparseArray.length();
        }
        assert (sparseArray.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        int[] nArray = sparseArray.getElementIndices();
        this.nonZeroValues += nArray.length;
        try {
            this.matrixDos.writeInt(nArray.length);
            for (int n : nArray) {
                this.matrixDos.writeInt(n);
                this.matrixDos.writeFloat(sparseArray.get(n).floatValue());
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return ++this.curCol;
    }

    @Override
    public synchronized int addColumn(Vector vector) {
        double d;
        int n;
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        DoubleVector doubleVector = Vectors.asDouble(vector);
        if (doubleVector.length() > this.numRows) {
            this.numRows = doubleVector.length();
        }
        assert (doubleVector.length() != Integer.MAX_VALUE) : "adding a column whose length is Integer.MAX_VALUE (was likley left unspecified in the  constructor).";
        if (doubleVector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            int[] nArray = sparseVector.getNonZeroIndices();
            this.nonZeroValues += nArray.length;
            System.out.println(nArray.length);
            try {
                this.matrixDos.writeInt(nArray.length);
                for (int n2 : nArray) {
                    double d2 = doubleVector.get(n2);
                    this.matrixDos.writeInt(n2);
                    this.matrixDos.writeFloat((float)d2);
                }
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
        int n3 = 0;
        for (n = 0; n < doubleVector.length(); ++n) {
            d = doubleVector.get(n);
            if (d == 0.0) continue;
            ++n3;
        }
        this.nonZeroValues += n3;
        try {
            this.matrixDos.writeInt(n3);
            for (n = 0; n < doubleVector.length(); ++n) {
                d = doubleVector.get(n);
                if (d == 0.0) continue;
                this.matrixDos.writeInt(n);
                this.matrixDos.writeFloat((float)d);
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return ++this.curCol;
    }

    @Override
    public synchronized void finish() {
        if (!this.isFinished) {
            Object object;
            this.isFinished = true;
            try {
                this.matrixDos.close();
                File file = this.transposeData ? this.transposedMatrixFile : this.matrixFile;
                object = new RandomAccessFile(file, "rw");
                ((RandomAccessFile)object).writeInt(this.numRows);
                ((RandomAccessFile)object).writeInt(this.curCol);
                ((RandomAccessFile)object).writeInt(this.nonZeroValues);
                ((RandomAccessFile)object).close();
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            if (this.transposeData) {
                boolean bl = false;
                try {
                    object = "svd  -r sb  -w sb -t -c " + this.transposedMatrixFile + " " + this.matrixFile;
                    Process process = Runtime.getRuntime().exec((String)object);
                    LOGGER.fine("transposing svdlibc sparse matrix: " + (String)object);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    StringBuilder stringBuilder = new StringBuilder("SVDLIBC output:\n");
                    String string = null;
                    while ((string = bufferedReader2.readLine()) != null) {
                        stringBuilder.append(string).append("\n");
                    }
                    LOGGER.fine(stringBuilder.toString());
                    int n = process.waitFor();
                    LOGGER.fine("svdlibc exit status: " + n);
                    if (n != 0) {
                        StringBuilder stringBuilder2 = new StringBuilder();
                        String string2 = null;
                        while ((string2 = bufferedReader2.readLine()) != null) {
                            stringBuilder2.append(string2).append("\n");
                        }
                        LOGGER.warning("svdlibc exited with error status.  stderr:\n" + stringBuilder2.toString());
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    bl = true;
                    LOGGER.log(Level.WARNING, "an exception occurred when trying to transpose with svdlibc; retrying with Java code", exception);
                }
                if (bl) {
                    LOGGER.fine("retrying failed svdlibc transpose with MatrixIO transpose");
                    try {
                        this.matrixFile = MatrixIO.convertFormat(this.transposedMatrixFile, MatrixIO.Format.SVDLIBC_SPARSE_BINARY, MatrixIO.Format.SVDLIBC_SPARSE_BINARY, true);
                    }
                    catch (IOException iOException) {
                        throw new IOError(iOException);
                    }
                }
            }
        }
    }

    @Override
    public synchronized File getFile() {
        if (!this.isFinished) {
            throw new IllegalStateException("Cannot access matrix file until finished has been called");
        }
        return this.matrixFile;
    }

    @Override
    public MatrixIO.Format getMatrixFormat() {
        return MatrixIO.Format.SVDLIBC_SPARSE_BINARY;
    }

    @Override
    public MatrixFile getMatrixFile() {
        return new MatrixFile(this.getFile(), this.getMatrixFormat());
    }

    @Override
    public synchronized boolean isFinished() {
        return this.isFinished;
    }
}

