/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIOException;
import edu.ucla.sspace.matrix.SimpleEntry;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SvdlibcSparseBinaryFileIterator
implements Iterator<MatrixEntry> {
    private final DataInputStream dis;
    private MatrixEntry next;
    private int entry;
    private int nzEntriesInMatrix;
    private int curCol;
    private int nzInCurCol;
    private int curColEntry;

    public SvdlibcSparseBinaryFileIterator(File file) throws IOException {
        this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int n = this.dis.readInt();
        int n2 = this.dis.readInt();
        this.nzEntriesInMatrix = this.dis.readInt();
        this.nzInCurCol = this.dis.readInt();
        this.entry = 0;
        this.curCol = 0;
        this.curColEntry = 0;
        this.advance();
    }

    private void advance() throws IOException {
        if (this.entry >= this.nzEntriesInMatrix) {
            this.next = null;
            this.dis.close();
        } else {
            try {
                while (this.curColEntry == this.nzInCurCol) {
                    this.curColEntry = 0;
                    this.nzInCurCol = this.dis.readInt();
                    ++this.curCol;
                }
                int n = this.dis.readInt();
                double d = this.dis.readFloat();
                this.next = new SimpleEntry(n, this.curCol, d);
                ++this.curColEntry;
                ++this.entry;
            }
            catch (IOException iOException) {
                throw new MatrixIOException("Missing data when reading.  Truncated file?", iOException);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MatrixEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        MatrixEntry matrixEntry = this.next;
        try {
            this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return matrixEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }
}

