/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.RowMaskedMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import java.util.BitSet;
import java.util.Set;

public class SparseRowMaskedMatrix
extends RowMaskedMatrix
implements SparseMatrix {
    private final SparseMatrix matrix;

    public SparseRowMaskedMatrix(SparseMatrix sparseMatrix, BitSet bitSet) {
        super((Matrix)sparseMatrix, bitSet);
        this.matrix = sparseMatrix;
    }

    public SparseRowMaskedMatrix(SparseMatrix sparseMatrix, Set<Integer> set) {
        super((Matrix)sparseMatrix, set);
        this.matrix = sparseMatrix;
    }

    public SparseRowMaskedMatrix(SparseMatrix sparseMatrix, int[] nArray) {
        super((Matrix)sparseMatrix, nArray);
        if (sparseMatrix instanceof SparseRowMaskedMatrix) {
            SparseRowMaskedMatrix sparseRowMaskedMatrix = (SparseRowMaskedMatrix)sparseMatrix;
            this.matrix = sparseRowMaskedMatrix.matrix;
        } else {
            this.matrix = sparseMatrix;
        }
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        int n2 = this.rows();
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(n2);
        for (int i = 0; i < n2; ++i) {
            double d = this.get(i, n);
            if (d == 0.0) continue;
            sparseHashDoubleVector.set(i, d);
        }
        return sparseHashDoubleVector;
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        return this.matrix.getRowVector(this.getRealRow(n));
    }
}

