/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.DiagonalMatrix;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.matrix.SvdlibjDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SVD {
    private static final Logger SVD_LOGGER = Logger.getLogger(SVD.class.getName());
    private static URLClassLoader coltClassLoader = null;

    private SVD() {
    }

    static Algorithm getFastestAvailableAlgorithm() {
        if (SVD.isSVDLIBCavailable()) {
            return Algorithm.SVDLIBC;
        }
        return Algorithm.SVDLIBJ;
    }

    public static Matrix[] svd(Matrix matrix, int n) {
        return SVD.svd(matrix, SVD.getFastestAvailableAlgorithm(), n);
    }

    public static Matrix[] svd(Matrix matrix, Algorithm algorithm, int n) {
        if (algorithm.equals((Object)Algorithm.ANY)) {
            algorithm = SVD.getFastestAvailableAlgorithm();
        }
        if (algorithm == null) {
            throw new UnsupportedOperationException("No SVD algorithm is available on this system");
        }
        MatrixIO.Format format = null;
        switch (algorithm) {
            case SVDLIBJ: {
                return SvdlibjDriver.svd(matrix, n);
            }
            case COLT: {
                return SVD.coltSVD(matrix.toDenseArray(), !(matrix instanceof SparseMatrix), n);
            }
            case JAMA: {
                return SVD.jamaSVD(matrix.toDenseArray(), n);
            }
            case SVDLIBC: {
                format = MatrixIO.Format.SVDLIBC_SPARSE_BINARY;
                break;
            }
            default: {
                format = MatrixIO.Format.MATLAB_SPARSE;
            }
        }
        try {
            File file = File.createTempFile("matrix-svd", ".dat");
            file.deleteOnExit();
            MatrixIO.writeMatrix(matrix, file, format);
            return SVD.svd(file, algorithm, format, n);
        }
        catch (IOException iOException) {
            SVD_LOGGER.log(Level.SEVERE, "convertFormat", iOException);
            throw new UnsupportedOperationException("SVD algorithm failed in writing matrix to disk");
        }
    }

    public static Matrix[] svd(File file, int n) {
        return SVD.svd(file, Algorithm.ANY, MatrixIO.Format.MATLAB_SPARSE, n);
    }

    public static Matrix[] svd(File file, Algorithm algorithm, int n) {
        return SVD.svd(file, algorithm, MatrixIO.Format.MATLAB_SPARSE, n);
    }

    public static Matrix[] svd(File file, MatrixIO.Format format, int n) {
        return SVD.svd(file, Algorithm.ANY, format, n);
    }

    public static Matrix[] svd(File file, Algorithm algorithm, MatrixIO.Format format, int n) {
        try {
            File file2 = null;
            switch (algorithm) {
                case SVDLIBC: {
                    switch (format) {
                        case SVDLIBC_DENSE_BINARY: 
                        case SVDLIBC_DENSE_TEXT: 
                        case SVDLIBC_SPARSE_TEXT: 
                        case SVDLIBC_SPARSE_BINARY: {
                            file2 = file;
                            break;
                        }
                        default: {
                            SVD_LOGGER.fine("converting input matrix format from" + (Object)((Object)format) + " to SVDLIBC " + "ready format");
                            file2 = MatrixIO.convertFormat(file, format, MatrixIO.Format.SVDLIBC_SPARSE_BINARY);
                            format = MatrixIO.Format.SVDLIBC_SPARSE_BINARY;
                        }
                    }
                    return SVD.svdlibc(file2, n, format);
                }
                case SVDLIBJ: {
                    return SvdlibjDriver.svd(file, format, n);
                }
                case JAMA: {
                    double[][] dArray = MatrixIO.readMatrixArray(file, format);
                    return SVD.jamaSVD(dArray, n);
                }
                case MATLAB: {
                    if (!format.equals((Object)MatrixIO.Format.MATLAB_SPARSE)) {
                        file = MatrixIO.convertFormat(file, format, MatrixIO.Format.MATLAB_SPARSE);
                    }
                    return SVD.matlabSVDS(file, n);
                }
                case OCTAVE: {
                    if (!format.equals((Object)MatrixIO.Format.MATLAB_SPARSE)) {
                        file = MatrixIO.convertFormat(file, format, MatrixIO.Format.MATLAB_SPARSE);
                    }
                    return SVD.octaveSVDS(file, n);
                }
                case COLT: {
                    double[][] dArray = MatrixIO.readMatrixArray(file, format);
                    return SVD.coltSVD(dArray, Matrices.isDense(format), n);
                }
                case ANY: {
                    if (SVD.isSVDLIBCavailable()) {
                        try {
                            switch (format) {
                                case SVDLIBC_DENSE_BINARY: 
                                case SVDLIBC_DENSE_TEXT: 
                                case SVDLIBC_SPARSE_TEXT: 
                                case SVDLIBC_SPARSE_BINARY: {
                                    file2 = file;
                                    break;
                                }
                                default: {
                                    SVD_LOGGER.fine("converting input matrix format from" + (Object)((Object)format) + " to SVDLIBC" + " ready format");
                                    file2 = MatrixIO.convertFormat(file, format, MatrixIO.Format.SVDLIBC_SPARSE_BINARY);
                                    format = MatrixIO.Format.SVDLIBC_SPARSE_BINARY;
                                }
                            }
                            return SVD.svdlibc(file2, n, format);
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            break;
                        }
                    }
                    return SvdlibjDriver.svd(file, format, n);
                }
            }
        }
        catch (IOException iOException) {
            SVD_LOGGER.log(Level.SEVERE, "convertFormat", iOException);
        }
        throw new UnsupportedOperationException("Unknown algorithm: " + (Object)((Object)algorithm));
    }

    private static boolean isJAMAavailable() {
        try {
            Class<?> clazz = SVD.loadJamaMatrixClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static Class<?> loadJamaMatrixClass() throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName("Jama.Matrix");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = System.getProperty("jama.path");
            if (string == null) {
                throw classNotFoundException;
            }
            File file = new File(string);
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
                Class<?> clazz = Class.forName("Jama.Matrix", true, uRLClassLoader);
                return clazz;
            }
            catch (Exception exception) {
                throw classNotFoundException;
            }
        }
    }

    private static boolean isColtAvailable() {
        try {
            Class<?> clazz = SVD.loadColtSparseMatrixClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static Class<?> loadColtSparseMatrixClass() throws ClassNotFoundException {
        String string = "cern.colt.matrix.impl.SparseDoubleMatrix2D";
        return SVD.loadColtClass(string);
    }

    private static Class<?> loadColtDenseMatrixClass() throws ClassNotFoundException {
        String string = "cern.colt.matrix.impl.DenseDoubleMatrix2D";
        return SVD.loadColtClass(string);
    }

    private static Class<?> loadColtSVDClass() throws ClassNotFoundException {
        String string = "cern.colt.matrix.linalg.SingularValueDecomposition";
        return SVD.loadColtClass(string);
    }

    private static Class<?> loadColtClass(String string) throws ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = System.getProperty("colt.path");
            if (string2 == null) {
                throw classNotFoundException;
            }
            File file = new File(string2);
            try {
                if (coltClassLoader == null) {
                    coltClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
                }
                Class<?> clazz = Class.forName(string, true, coltClassLoader);
                return clazz;
            }
            catch (Exception exception) {
                throw classNotFoundException;
            }
        }
    }

    private static boolean isSVDLIBCavailable() {
        try {
            Process process = Runtime.getRuntime().exec("svd");
            process.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isOctaveAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("octave -v");
            process.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isMatlabAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("matlab -h");
            process.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    static Matrix[] jamaSVD(double[][] dArray, int n) {
        try {
            SVD_LOGGER.fine("attempting JAMA");
            SVD.isJAMAavailable();
            int n2 = dArray.length;
            int n3 = dArray[0].length;
            Class<?> clazz = SVD.loadJamaMatrixClass();
            Constructor<?> constructor = clazz.getConstructor(double[][].class);
            Object obj = constructor.newInstance(new Object[]{dArray});
            Method method = clazz.getMethod("svd", new Class[0]);
            Object object = method.invoke(obj, new Object[0]);
            String[] stringArray = new String[]{"getU", "getS", "getV"};
            String[] stringArray2 = new String[]{"JAMA-U", "JAMA-S", "JAMA-V"};
            Matrix[] matrixArray = new Matrix[3];
            block11: for (int i = 0; i < 3; ++i) {
                Method method2 = object.getClass().getMethod(stringArray[i], new Class[0]);
                Object object2 = method2.invoke(object, new Object[0]);
                Method method3 = object2.getClass().getMethod("getArray", new Class[0]);
                double[][] dArray2 = (double[][])method3.invoke(object2, new Object[0]);
                switch (i) {
                    case 0: {
                        int n4;
                        int n5;
                        Matrix matrix = Matrices.create(n2, n, Matrix.Type.DENSE_IN_MEMORY);
                        for (n5 = 0; n5 < n2; ++n5) {
                            for (n4 = 0; n4 < n; ++n4) {
                                matrix.set(n5, n4, dArray2[n5][n4]);
                            }
                        }
                        matrixArray[i] = matrix;
                        continue block11;
                    }
                    case 1: {
                        int n5;
                        Matrix matrix = new DiagonalMatrix(n);
                        for (n5 = 0; n5 < n; ++n5) {
                            matrix.set(n5, n5, dArray2[n5][n5]);
                        }
                        matrixArray[i] = matrix;
                        continue block11;
                    }
                    case 2: {
                        int n4;
                        int n5;
                        Matrix matrix = Matrices.create(n, n3, Matrix.Type.DENSE_ON_DISK);
                        for (n5 = 0; n5 < n; ++n5) {
                            for (n4 = 0; n4 < n3; ++n4) {
                                matrix.set(n5, n4, dArray2[n4][n5]);
                            }
                        }
                        matrixArray[i] = matrix;
                    }
                }
            }
            return matrixArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            SVD_LOGGER.log(Level.SEVERE, "JAMA", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SVD_LOGGER.log(Level.SEVERE, "JAMA", noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            SVD_LOGGER.log(Level.SEVERE, "JAMA", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            SVD_LOGGER.log(Level.SEVERE, "JAMA", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            SVD_LOGGER.log(Level.SEVERE, "JAMA", invocationTargetException);
        }
        throw new UnsupportedOperationException("JAMA-based SVD is not available on this system");
    }

    static Matrix[] coltSVD(double[][] dArray, boolean bl, int n) {
        try {
            SVD_LOGGER.fine("attempting COLT");
            int n2 = dArray.length;
            int n3 = dArray[0].length;
            Class<?> clazz = bl ? SVD.loadColtDenseMatrixClass() : SVD.loadColtSparseMatrixClass();
            Constructor<?> constructor = clazz.getConstructor(double[][].class);
            Object obj = constructor.newInstance(new Object[]{dArray});
            dArray = null;
            Class<?> clazz2 = SVD.loadColtSVDClass();
            Class<?> clazz3 = SVD.loadColtClass("cern.colt.matrix.DoubleMatrix2D");
            Constructor<?> constructor2 = clazz2.getConstructor(clazz3);
            Object obj2 = constructor2.newInstance(obj);
            Matrix[] matrixArray = new Matrix[3];
            String[] stringArray = new String[]{"getU", "getS", "getV"};
            String[] stringArray2 = new String[]{"COLT-U", "COLT-S", "COLT-V"};
            block11: for (int i = 0; i < 3; ++i) {
                Method method = obj2.getClass().getMethod(stringArray[i], new Class[0]);
                Object object = method.invoke(obj2, new Object[0]);
                Method method2 = object.getClass().getMethod("toArray", new Class[0]);
                switch (i) {
                    case 0: {
                        int n4;
                        int n5;
                        Object object2 = (double[][])method2.invoke(object, new Object[0]);
                        Object object3 = Matrices.create(n2, n, Matrix.Type.DENSE_IN_MEMORY);
                        for (n5 = 0; n5 < n2; ++n5) {
                            for (n4 = 0; n4 < n; ++n4) {
                                object3.set(n5, n4, (double)object2[n5][n4]);
                            }
                        }
                        matrixArray[i] = object3;
                        continue block11;
                    }
                    case 1: {
                        int n5;
                        Object object2 = new DiagonalMatrix(n);
                        Object object3 = object.getClass().getMethod("get", Integer.TYPE, Integer.TYPE);
                        for (n5 = 0; n5 < n; ++n5) {
                            double d = (Double)((Method)object3).invoke(object, n5, n5);
                            object2.set(n5, n5, d);
                        }
                        matrixArray[i] = object2;
                        continue block11;
                    }
                    case 2: {
                        int n4;
                        int n5;
                        Object object2 = (double[][])method2.invoke(object, new Object[0]);
                        Object object3 = Matrices.create(n, n3, Matrix.Type.DENSE_ON_DISK);
                        for (n5 = 0; n5 < n; ++n5) {
                            for (n4 = 0; n4 < n3; ++n4) {
                                object3.set(n5, n4, (double)object2[n5][n4]);
                            }
                        }
                        matrixArray[i] = object3;
                    }
                }
            }
            return matrixArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            SVD_LOGGER.log(Level.SEVERE, "COLT", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SVD_LOGGER.log(Level.SEVERE, "COLT", noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            SVD_LOGGER.log(Level.SEVERE, "COLT", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            SVD_LOGGER.log(Level.SEVERE, "COLT", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            SVD_LOGGER.log(Level.SEVERE, "COLT", invocationTargetException);
        }
        throw new UnsupportedOperationException("COLT-based SVD is not available on this system");
    }

    static Matrix[] svdlibc(File file, int n, MatrixIO.Format format) {
        try {
            String string = "";
            switch (format) {
                case SVDLIBC_DENSE_BINARY: {
                    string = " -r db ";
                    break;
                }
                case SVDLIBC_DENSE_TEXT: {
                    string = " -r dt ";
                    break;
                }
                case SVDLIBC_SPARSE_BINARY: {
                    string = " -r sb ";
                    break;
                }
                case SVDLIBC_SPARSE_TEXT: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Format type is not accepted");
                }
            }
            File file2 = File.createTempFile("svdlibc", ".dat");
            file2.deleteOnExit();
            String string2 = file2.getAbsolutePath();
            SVD_LOGGER.fine("creating SVDLIBC factor matrices at: " + string2);
            String string3 = "svd -o " + string2 + string + " -w db " + " -d " + n + " " + file.getAbsolutePath();
            SVD_LOGGER.fine(string3);
            Process process = Runtime.getRuntime().exec(string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder("SVDLIBC output:\n");
            String string4 = null;
            while ((string4 = bufferedReader2.readLine()) != null) {
                stringBuilder.append(string4).append("\n");
            }
            SVD_LOGGER.fine(stringBuilder.toString());
            int n2 = process.waitFor();
            SVD_LOGGER.fine("svdlibc exit status: " + n2);
            if (n2 == 0) {
                File file3 = new File(string2 + "-Ut");
                File file4 = new File(string2 + "-S");
                File file5 = new File(string2 + "-Vt");
                return new Matrix[]{MatrixIO.readMatrix(file3, MatrixIO.Format.SVDLIBC_DENSE_BINARY, Matrix.Type.DENSE_IN_MEMORY, true), SVD.readSVDLIBCsingularVector(file4), MatrixIO.readMatrix(file5, MatrixIO.Format.SVDLIBC_DENSE_BINARY, Matrix.Type.DENSE_ON_DISK)};
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            String string5 = null;
            while ((string5 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string5).append("\n");
            }
            SVD_LOGGER.warning("svdlibc exited with error status.  stderr:\n" + stringBuilder2.toString());
        }
        catch (IOException iOException) {
            SVD_LOGGER.log(Level.SEVERE, "SVDLIBC", iOException);
        }
        catch (InterruptedException interruptedException) {
            SVD_LOGGER.log(Level.SEVERE, "SVDLIBC", interruptedException);
        }
        throw new UnsupportedOperationException("SVDLIBC is not correctly installed on this system");
    }

    private static Matrix readSVDLIBCsingularVector(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = -1;
        int n2 = 0;
        Matrix matrix = null;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (n == -1) {
                    n = Integer.parseInt(stringArray[i]);
                    matrix = new DiagonalMatrix(n);
                    continue;
                }
                matrix.set(n2, n2, Double.parseDouble(stringArray[i]));
                ++n2;
            }
        }
        return matrix;
    }

    static Matrix[] matlabSVDS(File file, int n) {
        try {
            File file2 = File.createTempFile("matlab-svds-U", ".dat");
            File file3 = File.createTempFile("matlab-svds-S", ".dat");
            File file4 = File.createTempFile("matlab-svds-V", ".dat");
            if (SVD_LOGGER.isLoggable(Level.FINE)) {
                SVD_LOGGER.fine("writing Matlab output to files:\n  " + file2 + "\n" + "  " + file3 + "\n" + "  " + file4 + "\n");
            }
            file2.deleteOnExit();
            file3.deleteOnExit();
            file4.deleteOnExit();
            String string = "matlab -nodisplay -nosplash -nojvm";
            SVD_LOGGER.fine(string);
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            PrintWriter printWriter = new PrintWriter(process.getOutputStream());
            printWriter.println("Z = load('" + file.getAbsolutePath() + "','-ascii');\n" + "A = spconvert(Z);\n" + "% Remove the raw data file to save space\n" + "clear Z;\n" + "[U, S, V] = svds(A, " + n + " );\n" + "save " + file2.getAbsolutePath() + " U -ASCII\n" + "save " + file3.getAbsolutePath() + " S -ASCII\n" + "save " + file4.getAbsolutePath() + " V -ASCII\n" + "fprintf('Matlab Finished\\n');");
            printWriter.close();
            StringBuilder stringBuilder = new StringBuilder("Matlab svds output:\n");
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
                if (!string2.equals("Matlab Finished")) continue;
                process.destroy();
            }
            SVD_LOGGER.fine(stringBuilder.toString());
            int n2 = process.waitFor();
            SVD_LOGGER.fine("Matlab svds exit status: " + n2);
            if (n2 == 0) {
                return new Matrix[]{MatrixIO.readMatrix(file2, MatrixIO.Format.DENSE_TEXT, Matrix.Type.DENSE_IN_MEMORY), MatrixIO.readMatrix(file3, MatrixIO.Format.DENSE_TEXT, Matrix.Type.SPARSE_ON_DISK), MatrixIO.readMatrix(file4, MatrixIO.Format.DENSE_TEXT, Matrix.Type.DENSE_ON_DISK, true)};
            }
        }
        catch (IOException iOException) {
            SVD_LOGGER.log(Level.SEVERE, "Matlab svds", iOException);
        }
        catch (InterruptedException interruptedException) {
            SVD_LOGGER.log(Level.SEVERE, "Matlab svds", interruptedException);
        }
        throw new UnsupportedOperationException("Matlab svds is not correctly installed on this system");
    }

    static Matrix[] octaveSVDS(File file, int n) {
        try {
            File file2 = File.createTempFile("octave-svds", ".m");
            File file3 = File.createTempFile("octave-svds-U", ".dat");
            File file4 = File.createTempFile("octave-svds-S", ".dat");
            File file5 = File.createTempFile("octave-svds-V", ".dat");
            file2.deleteOnExit();
            file3.deleteOnExit();
            file4.deleteOnExit();
            file5.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(file2);
            printWriter.println("Z = load('" + file.getAbsolutePath() + "','-ascii');\n" + "A = spconvert(Z);\n" + "% Remove the raw data file to save space\n" + "clear Z;\n" + "[U, S, V] = svds(A, " + n + " );\n" + "save(\"-ascii\", \"" + file3.getAbsolutePath() + "\", \"U\");\n" + "save(\"-ascii\", \"" + file4.getAbsolutePath() + "\", \"S\");\n" + "save(\"-ascii\", \"" + file5.getAbsolutePath() + "\", \"V\");\n" + "fprintf('Octave Finished\\n');\n");
            printWriter.close();
            String string = "octave " + file2.getAbsolutePath();
            SVD_LOGGER.fine(string);
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder("Octave svds output:\n");
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2).append("\n");
            }
            SVD_LOGGER.fine(stringBuilder.toString());
            int n2 = process.waitFor();
            SVD_LOGGER.fine("Octave svds exit status: " + n2);
            if (n2 == 0) {
                return new Matrix[]{MatrixIO.readMatrix(file3, MatrixIO.Format.DENSE_TEXT, Matrix.Type.DENSE_IN_MEMORY), MatrixIO.readMatrix(file4, MatrixIO.Format.DENSE_TEXT, Matrix.Type.SPARSE_ON_DISK), MatrixIO.readMatrix(file5, MatrixIO.Format.DENSE_TEXT, Matrix.Type.DENSE_ON_DISK, true)};
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = null;
            while ((string3 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string3).append("\n");
            }
            SVD_LOGGER.warning("Octave exited with error status.  stderr:\n" + stringBuilder2.toString());
        }
        catch (IOException iOException) {
            SVD_LOGGER.log(Level.SEVERE, "Octave svds", iOException);
        }
        catch (InterruptedException interruptedException) {
            SVD_LOGGER.log(Level.SEVERE, "Octave svds", interruptedException);
        }
        throw new UnsupportedOperationException("Octave svds is not correctly installed on this system");
    }

    public static enum Algorithm {
        SVDLIBC,
        SVDLIBJ,
        MATLAB,
        OCTAVE,
        JAMA,
        COLT,
        ANY;

    }
}

