/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.ScaledDoubleVector;

public class RowScaledMatrix
implements Matrix {
    private final Matrix m;
    private final DoubleVector scales;

    public RowScaledMatrix(Matrix matrix, DoubleVector doubleVector) {
        this.m = matrix;
        this.scales = doubleVector;
    }

    @Override
    public int columns() {
        return this.m.columns();
    }

    @Override
    public double get(int n, int n2) {
        return this.m.get(n, n2) * this.scales.get(n);
    }

    @Override
    public double[] getColumn(int n) {
        throw new UnsupportedOperationException("Cannot access column");
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        throw new UnsupportedOperationException("Cannot access column");
    }

    @Override
    public double[] getRow(int n) {
        double[] dArray = this.m.getRow(n);
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = i;
            dArray[n2] = dArray[n2] * this.scales.get(i);
        }
        return dArray;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        return new ScaledDoubleVector(this.m.getRowVector(n), this.scales.get(n));
    }

    @Override
    public int rows() {
        return this.m.rows();
    }

    @Override
    public void set(int n, int n2, double d) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    @Override
    public void setRow(int n, double[] dArray) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        throw new UnsupportedOperationException("Cannot set values");
    }

    @Override
    public double[][] toDenseArray() {
        return this.m.toDenseArray();
    }
}

