/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.TransformStatistics;
import java.io.File;

public class PointWiseMutualInformationTransform
extends BaseTransform {
    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new PointWiseMutualInformationGlobalTransform(matrix);
    }

    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new PointWiseMutualInformationGlobalTransform(file, format);
    }

    public String toString() {
        return "PMI";
    }

    public class PointWiseMutualInformationGlobalTransform
    implements GlobalTransform {
        private double[] rowCounts;
        private double[] colCounts;
        private double matrixSum;

        public PointWiseMutualInformationGlobalTransform(Matrix matrix) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(matrix);
            this.rowCounts = matrixStatistics.rowSums;
            this.colCounts = matrixStatistics.columnSums;
            this.matrixSum = matrixStatistics.matrixSum;
        }

        public PointWiseMutualInformationGlobalTransform(File file, MatrixIO.Format format) {
            TransformStatistics.MatrixStatistics matrixStatistics = TransformStatistics.extractStatistics(file, format);
            this.rowCounts = matrixStatistics.rowSums;
            this.colCounts = matrixStatistics.columnSums;
            this.matrixSum = matrixStatistics.matrixSum;
        }

        @Override
        public double transform(int n, int n2, double d) {
            return Math.log(d * this.matrixSum / (this.rowCounts[n] * this.colCounts[n2]));
        }
    }
}

