/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.util.Duple;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.DoubleBuffer;
import java.nio.channels.FileChannel;

public class OnDiskMatrix
implements Matrix {
    private static final int BYTES_PER_DOUBLE = 8;
    private static final int MAX_ELEMENTS_PER_REGION = 0xFFFFFFF;
    private final DoubleBuffer[] matrixRegions;
    private final File[] backingFiles;
    private final int rows;
    private final int cols;

    public OnDiskMatrix(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("dimensions must be positive");
        }
        this.rows = n;
        this.cols = n2;
        int n3 = (int)((long)n * (long)n2 / 0xFFFFFFFL) + 1;
        this.matrixRegions = new DoubleBuffer[n3];
        this.backingFiles = new File[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = i + 1 == n3 ? (int)((long)n * (long)n2 % 0xFFFFFFFL * 8L) : 0x7FFFFFF8;
            Duple<DoubleBuffer, File> duple = OnDiskMatrix.createTempBuffer(n4);
            this.matrixRegions[i] = (DoubleBuffer)duple.x;
            this.backingFiles[i] = (File)duple.y;
        }
    }

    private static Duple<DoubleBuffer, File> createTempBuffer(int n) {
        try {
            File file = File.createTempFile("OnDiskMatrix", ".matrix");
            file.deleteOnExit();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel fileChannel = randomAccessFile.getChannel();
            DoubleBuffer doubleBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, n).asDoubleBuffer();
            fileChannel.close();
            return new Duple<DoubleBuffer, File>(doubleBuffer, file);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("row: " + n);
        }
        if (n2 < 0 || n2 >= this.cols) {
            throw new ArrayIndexOutOfBoundsException("column: " + n2);
        }
    }

    @Override
    public double get(int n, int n2) {
        int n3 = this.getMatrixRegion(n, n2);
        int n4 = this.getRegionOffset(n, n2);
        return this.matrixRegions[n3].get(n4);
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            dArray[i] = this.get(i, n);
        }
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        return new DenseVector(this.getColumn(n));
    }

    @Override
    public double[] getRow(int n) {
        int n2 = this.getMatrixRegion(n, 0L);
        int n3 = this.getMatrixRegion(n + 1, 0L);
        double[] dArray = new double[this.cols];
        if (n2 == n3) {
            int n4 = this.getRegionOffset(n, 0L);
            DoubleBuffer doubleBuffer = this.matrixRegions[n2];
            for (int i = 0; i < this.cols; ++i) {
                dArray[i] = doubleBuffer.get(i + n4);
            }
        } else {
            DoubleBuffer doubleBuffer = this.matrixRegions[n2];
            DoubleBuffer doubleBuffer2 = this.matrixRegions[n3];
            int n5 = this.getRegionOffset(n, 0L);
            int n6 = 0;
            while (n5 + n6 < 0xFFFFFFF) {
                dArray[n6] = doubleBuffer.get(n6 + n5);
                ++n6;
            }
            int n7 = 0;
            while (n6 < dArray.length) {
                dArray[n6] = doubleBuffer2.get(n7);
                ++n7;
                ++n6;
            }
        }
        return dArray;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        return new DenseVector(this.getRow(n));
    }

    @Override
    public int columns() {
        return this.cols;
    }

    private int getMatrixRegion(long l, long l2) {
        long l3 = l * (long)this.cols + l2;
        return (int)(l3 / 0xFFFFFFFL);
    }

    private int getRegionOffset(long l, long l2) {
        long l3 = l * (long)this.cols + l2;
        return (int)(l3 % 0xFFFFFFFL);
    }

    @Override
    public void set(int n, int n2, double d) {
        int n3 = this.getMatrixRegion(n, n2);
        int n4 = this.getRegionOffset(n, n2);
        this.matrixRegions[n3].put(n4, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        for (int i = 0; i < this.rows; ++i) {
            this.set(i, n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        for (int i = 0; i < this.rows; ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        if (dArray.length != this.cols) {
            throw new IllegalArgumentException("The number of values does not match the number of columns");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.set(n, i, dArray[i]);
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.cols) {
            throw new IllegalArgumentException("The number of values does not match the number of columns");
        }
        if (doubleVector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            for (int n2 : sparseVector.getNonZeroIndices()) {
                this.set(n, n2, doubleVector.get(n2));
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                this.set(n, i, doubleVector.get(i));
            }
        }
    }

    @Override
    public double[][] toDenseArray() {
        if (this.matrixRegions.length > 1) {
            throw new UnsupportedOperationException("matrix is too large to fit into memory");
        }
        double[][] dArray = new double[this.rows][this.cols];
        DoubleBuffer doubleBuffer = this.matrixRegions[0];
        doubleBuffer.rewind();
        for (int i = 0; i < this.rows; ++i) {
            doubleBuffer.get(dArray[i]);
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    protected void finalize() {
        for (File file : this.backingFiles) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

