/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.ClutoSparseFileIterator;
import edu.ucla.sspace.matrix.DenseTextFileIterator;
import edu.ucla.sspace.matrix.FileTransformer;
import edu.ucla.sspace.matrix.GrowingSparseMatrix;
import edu.ucla.sspace.matrix.MatlabSparseFileIterator;
import edu.ucla.sspace.matrix.MatlabSparseFileTransformer;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIOException;
import edu.ucla.sspace.matrix.SvdlibcDenseBinaryFileIterator;
import edu.ucla.sspace.matrix.SvdlibcDenseBinaryFileTransformer;
import edu.ucla.sspace.matrix.SvdlibcDenseTextFileIterator;
import edu.ucla.sspace.matrix.SvdlibcDenseTextFileTransformer;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryFileIterator;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryFileTransformer;
import edu.ucla.sspace.matrix.SvdlibcSparseTextFileIterator;
import edu.ucla.sspace.matrix.SvdlibcSparseTextFileTransformer;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatrixIO {
    private static final Logger MATRIX_IO_LOGGER = Logger.getLogger(MatrixIO.class.getName());

    private MatrixIO() {
    }

    public static File convertFormat(File file, Format format, Format format2) throws IOException {
        return MatrixIO.convertFormat(file, format, format2, false);
    }

    public static File convertFormat(File file, Format format, Format format2, boolean bl) throws IOException {
        if (!bl && format.equals((Object)format2)) {
            return file;
        }
        switch (format) {
            case MATLAB_SPARSE: {
                if (format2.equals((Object)Format.SVDLIBC_SPARSE_TEXT)) {
                    File file2 = File.createTempFile("matlab-to-SVDLIBC-sparse-text", ".dat");
                    file2.deleteOnExit();
                    MatrixIO.matlabToSvdlibcSparseText(file, file2, bl);
                    return file2;
                }
                if (!format2.equals((Object)Format.SVDLIBC_SPARSE_BINARY)) break;
                File file3 = File.createTempFile("matlab-to-SVDLIBC-sparse-binary", ".dat");
                file3.deleteOnExit();
                MatrixIO.matlabToSvdlibcSparseBinary(file, file3, bl);
                return file3;
            }
            case SVDLIBC_SPARSE_BINARY: {
                if (!format2.equals((Object)Format.MATLAB_SPARSE)) break;
                File file4 = File.createTempFile("SVDLIBC-sparse-binary-to-Matlab", ".dat");
                file4.deleteOnExit();
                MatrixIO.svdlibcSparseBinaryToMatlab(file, file4, bl);
                return file4;
            }
        }
        File file5 = File.createTempFile("transposed", ".dat");
        Matrix matrix = MatrixIO.readMatrix(file, format, Matrix.Type.SPARSE_IN_MEMORY, true);
        MatrixIO.writeMatrix(matrix, file5, format2);
        matrix = null;
        return file5;
    }

    public static Iterator<MatrixEntry> getMatrixFileIterator(File file, Format format) throws IOException {
        switch (format) {
            case DENSE_TEXT: {
                return new DenseTextFileIterator(file);
            }
            case SVDLIBC_SPARSE_BINARY: {
                return new SvdlibcSparseBinaryFileIterator(file);
            }
            case SVDLIBC_SPARSE_TEXT: {
                return new SvdlibcSparseTextFileIterator(file);
            }
            case SVDLIBC_DENSE_BINARY: {
                return new SvdlibcDenseBinaryFileIterator(file);
            }
            case CLUTO_SPARSE: {
                return new ClutoSparseFileIterator(file);
            }
            case CLUTO_DENSE: 
            case SVDLIBC_DENSE_TEXT: {
                return new SvdlibcDenseTextFileIterator(file);
            }
            case MATLAB_SPARSE: {
                return new MatlabSparseFileIterator(file);
            }
        }
        throw new Error("Iterating over matrices of " + (Object)((Object)format) + " format is not " + "currently supported. Email " + "s-space-research-dev@googlegroups.com to request its" + "inclusion and it will be quickly added");
    }

    public static FileTransformer fileTransformer(Format format) {
        switch (format) {
            case MATLAB_SPARSE: {
                return new MatlabSparseFileTransformer();
            }
            case SVDLIBC_SPARSE_TEXT: {
                return new SvdlibcSparseTextFileTransformer();
            }
            case SVDLIBC_DENSE_TEXT: {
                return new SvdlibcDenseTextFileTransformer();
            }
            case SVDLIBC_SPARSE_BINARY: {
                return new SvdlibcSparseBinaryFileTransformer();
            }
            case SVDLIBC_DENSE_BINARY: {
                return new SvdlibcDenseBinaryFileTransformer();
            }
        }
        throw new UnsupportedOperationException("Transforming format " + (Object)((Object)format) + " is currently " + "not implemented.  Please email " + "s-space-research-dev@googlegroups.com to have this " + "implemented.");
    }

    private static void matlabToSvdlibcSparseText(File file, File file2, boolean bl) throws IOException {
        int n;
        int n2;
        MATRIX_IO_LOGGER.info("Converting from Matlab double values to SVDLIBC float values; possible loss of precision");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Object object = null;
        while ((object = bufferedReader.readLine()) != null) {
            String[] stringArray = ((String)object).split("\\s+");
            if (bl) {
                n2 = Integer.parseInt(stringArray[1]);
                n = Integer.parseInt(stringArray[0]);
            } else {
                n2 = Integer.parseInt(stringArray[0]);
                n = Integer.parseInt(stringArray[1]);
            }
            if (n2 > n3) {
                n3 = n2;
            }
            if (n > n4) {
                n4 = n;
            }
            ++n5;
            Integer n6 = (Integer)hashMap.get(n - 1);
            hashMap.put(n - 1, n6 == null ? 1 : n6 + 1);
        }
        bufferedReader.close();
        object = new PrintWriter(file2);
        ((PrintWriter)object).println(n3 + "\t" + n4 + "\t" + n5);
        int n7 = 1000;
        n2 = -1;
        n = 0;
        int n8 = n7;
        while (n < n3) {
            int n6;
            bufferedReader = new BufferedReader(new FileReader(file));
            int[] nArray = new int[n4];
            TreeMap<Integer, int[]> treeMap = new TreeMap<Integer, int[]>();
            TreeMap<Integer, float[]> treeMap2 = new TreeMap<Integer, float[]>();
            Object object2 = null;
            while ((object2 = bufferedReader.readLine()) != null) {
                int n9;
                String[] stringArray = ((String)object2).split("\\s+");
                if (bl) {
                    n6 = Integer.parseInt(stringArray[1]) - 1;
                    n9 = Integer.parseInt(stringArray[0]) - 1;
                } else {
                    n6 = Integer.parseInt(stringArray[0]) - 1;
                    n9 = Integer.parseInt(stringArray[1]) - 1;
                }
                float f = Double.valueOf(stringArray[2]).floatValue();
                if (n9 < n || n9 >= n8) continue;
                int[] nArray2 = (int[])treeMap.get(n9);
                float[] fArray = (float[])treeMap2.get(n9);
                if (nArray2 == null) {
                    nArray2 = new int[((Integer)hashMap.get(n9)).intValue()];
                    fArray = new float[((Integer)hashMap.get(n9)).intValue()];
                    treeMap.put(n9, nArray2);
                    treeMap2.put(n9, fArray);
                }
                int n10 = nArray[n9];
                nArray2[n10] = n6;
                fArray[n10] = f;
                int n11 = n9;
                nArray[n11] = nArray[n11] + 1;
            }
            bufferedReader.close();
            for (Map.Entry entry : treeMap.entrySet()) {
                int n12;
                n6 = (Integer)entry.getKey();
                int[] nArray3 = (int[])entry.getValue();
                float[] fArray = (float[])treeMap2.get(n6);
                if (n6 != n2) {
                    for (n12 = n2 + 1; n12 < n6; ++n12) {
                        ((PrintWriter)object).println(0);
                    }
                    n12 = (Integer)hashMap.get(n6);
                    n2 = n6;
                    ((PrintWriter)object).println(n12);
                }
                for (n12 = 0; n12 < nArray3.length; ++n12) {
                    ((PrintWriter)object).println(nArray3[n12] + " " + fArray[n12]);
                }
            }
            n = n8;
            n8 += n7;
        }
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void matlabToSvdlibcSparseBinary(File file, File file2, boolean bl) throws IOException {
        int n;
        int n2;
        MATRIX_IO_LOGGER.info("Converting from Matlab double values to SVDLIBC float values; possible loss of precision");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Object object = null;
        while ((object = bufferedReader.readLine()) != null) {
            String[] stringArray = ((String)object).split("\\s+");
            if (bl) {
                n2 = Integer.parseInt(stringArray[1]);
                n = Integer.parseInt(stringArray[0]);
            } else {
                n2 = Integer.parseInt(stringArray[0]);
                n = Integer.parseInt(stringArray[1]);
            }
            if (n2 > n3) {
                n3 = n2;
            }
            if (n > n4) {
                n4 = n;
            }
            ++n5;
            Integer n6 = (Integer)hashMap.get(n - 1);
            hashMap.put(n - 1, n6 == null ? 1 : n6 + 1);
        }
        bufferedReader.close();
        object = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
        ((DataOutputStream)object).writeInt(n3);
        ((DataOutputStream)object).writeInt(n4);
        ((DataOutputStream)object).writeInt(n5);
        int n7 = 1000;
        n2 = -1;
        n = 0;
        int n8 = n7;
        while (n < n3) {
            int n6;
            bufferedReader = new BufferedReader(new FileReader(file));
            int[] nArray = new int[n4];
            TreeMap<Integer, int[]> treeMap = new TreeMap<Integer, int[]>();
            TreeMap<Integer, float[]> treeMap2 = new TreeMap<Integer, float[]>();
            Object object2 = null;
            while ((object2 = bufferedReader.readLine()) != null) {
                int n9;
                String[] stringArray = ((String)object2).split("\\s+");
                if (bl) {
                    n6 = Integer.parseInt(stringArray[1]) - 1;
                    n9 = Integer.parseInt(stringArray[0]) - 1;
                } else {
                    n6 = Integer.parseInt(stringArray[0]) - 1;
                    n9 = Integer.parseInt(stringArray[1]) - 1;
                }
                float f = Double.valueOf(stringArray[2]).floatValue();
                if (n9 < n || n9 >= n8) continue;
                int[] nArray2 = (int[])treeMap.get(n9);
                float[] fArray = (float[])treeMap2.get(n9);
                if (nArray2 == null) {
                    nArray2 = new int[((Integer)hashMap.get(n9)).intValue()];
                    fArray = new float[((Integer)hashMap.get(n9)).intValue()];
                    treeMap.put(n9, nArray2);
                    treeMap2.put(n9, fArray);
                }
                int n10 = nArray[n9];
                nArray2[n10] = n6;
                fArray[n10] = f;
                int n11 = n9;
                nArray[n11] = nArray[n11] + 1;
            }
            bufferedReader.close();
            for (Map.Entry entry : treeMap.entrySet()) {
                int n12;
                n6 = (Integer)entry.getKey();
                int[] nArray3 = (int[])entry.getValue();
                float[] fArray = (float[])treeMap2.get(n6);
                if (n6 != n2) {
                    for (n12 = n2 + 1; n12 < n6; ++n12) {
                        ((DataOutputStream)object).writeInt(0);
                    }
                    n12 = (Integer)hashMap.get(n6);
                    n2 = n6;
                    ((DataOutputStream)object).writeInt(n12);
                }
                for (n12 = 0; n12 < nArray3.length; ++n12) {
                    ((DataOutputStream)object).writeInt(nArray3[n12]);
                    ((DataOutputStream)object).writeFloat(fArray[n12]);
                }
            }
            n = n8;
            n8 += n7;
        }
        ((FilterOutputStream)object).close();
    }

    private static void svdlibcSparseBinaryToMatlab(File file, File file2, boolean bl) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        PrintWriter printWriter = new PrintWriter(file2);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            int n6 = dataInputStream.readInt();
            int n7 = 0;
            while (n7 < n6) {
                int n8 = dataInputStream.readInt();
                float f = dataInputStream.readFloat();
                if (bl) {
                    printWriter.println(1 + n5 + " " + (1 + n8) + " " + f);
                } else {
                    printWriter.println(1 + n8 + " " + (1 + n5) + " " + f);
                }
                ++n7;
                ++n4;
            }
            ++n5;
        }
        dataInputStream.close();
        printWriter.close();
    }

    @Deprecated
    public static double[][] readMatrixArray(File file, Format format) throws IOException {
        return MatrixIO.readMatrix(file, format).toDenseArray();
    }

    public static Matrix readMatrix(File file, Format format) throws IOException {
        switch (format) {
            case MATLAB_SPARSE: 
            case SVDLIBC_SPARSE_BINARY: 
            case SVDLIBC_SPARSE_TEXT: 
            case CLUTO_SPARSE: {
                return MatrixIO.readMatrix(file, format, Matrix.Type.SPARSE_IN_MEMORY, false);
            }
            case DENSE_TEXT: 
            case SVDLIBC_DENSE_BINARY: 
            case CLUTO_DENSE: 
            case SVDLIBC_DENSE_TEXT: {
                return MatrixIO.readMatrix(file, format, Matrix.Type.DENSE_IN_MEMORY, false);
            }
        }
        throw new Error("Reading matrices of " + (Object)((Object)format) + " format is not " + "currently supported. Email " + "s-space-research-dev@googlegroups.com to request " + "its inclusion and it will be quickly added");
    }

    public static Matrix readMatrix(File file, Format format, Matrix.Type type) throws IOException {
        return MatrixIO.readMatrix(file, format, type, false);
    }

    public static Matrix readMatrix(File file, Format format, Matrix.Type type, boolean bl) throws IOException {
        try {
            switch (format) {
                case DENSE_TEXT: {
                    return MatrixIO.readDenseTextMatrix(file, type, bl);
                }
                case MATLAB_SPARSE: {
                    return MatrixIO.readMatlabSparse(file, type, bl);
                }
                case CLUTO_SPARSE: {
                    return MatrixIO.readClutoSparse(file, type, bl);
                }
                case SVDLIBC_SPARSE_TEXT: {
                    return MatrixIO.readSparseSVDLIBCtext(file, type, bl);
                }
                case CLUTO_DENSE: 
                case SVDLIBC_DENSE_TEXT: {
                    return MatrixIO.readDenseSVDLIBCtext(file, type, bl);
                }
                case SVDLIBC_SPARSE_BINARY: {
                    return MatrixIO.readSparseSVDLIBCbinary(file, type, bl);
                }
                case SVDLIBC_DENSE_BINARY: {
                    return MatrixIO.readDenseSVDLIBCbinary(file, type, bl);
                }
            }
        }
        catch (EOFException eOFException) {
            throw new MatrixIOException("Matrix file " + file + " appeared " + "truncated, or was missing expected values at the end of its " + "contents.");
        }
        throw new Error("Reading matrices of " + (Object)((Object)format) + " format is not " + "currently supported. Email " + "s-space-research-dev@googlegroups.com to request its " + "inclusion and it will be quickly added");
    }

    private static Matrix readClutoSparse(File file, Matrix.Type type, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String[] stringArray = bufferedReader.readLine().split("\\s+");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        Matrix matrix = bl ? Matrices.create(n2, n, type) : Matrices.create(n, n2, type);
        int n3 = 0;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray2 = string.split("\\s+");
            for (int i = 0; i < stringArray2.length; i += 2) {
                int n4 = Integer.parseInt(stringArray2[i]) - 1;
                double d = Double.parseDouble(stringArray2[i + 1]);
                if (bl) {
                    matrix.set(n4, n3, d);
                    continue;
                }
                matrix.set(n3, n4, d);
            }
            ++n3;
        }
        return matrix;
    }

    private static Matrix readDenseTextMatrix(File file, Matrix.Type type, boolean bl) throws IOException {
        int n;
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n2 = 0;
        int n3 = -1;
        Object object2 = null;
        while ((object2 = bufferedReader.readLine()) != null) {
            object = new Scanner((String)object2);
            n = 0;
            while (((Scanner)object).hasNextDouble()) {
                ++n;
                ((Scanner)object).nextDouble();
            }
            if (n3 == -1) {
                n3 = n;
            } else if (n3 != n) {
                throw new MatrixIOException("line " + (n2 + 1) + " contains an inconsistent number of columns");
            }
            ++n2;
        }
        bufferedReader.close();
        if (MATRIX_IO_LOGGER.isLoggable(Level.FINE)) {
            MATRIX_IO_LOGGER.fine("reading in text matrix with " + n2 + " rows and " + n3 + " cols");
        }
        object2 = new Scanner(file);
        object = bl ? Matrices.create(n3, n2, type) : Matrices.create(n2, n3, type);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                double d = ((Scanner)object2).nextDouble();
                if (bl) {
                    object.set(i, n, d);
                    continue;
                }
                object.set(n, i, d);
            }
        }
        ((Scanner)object2).close();
        return object;
    }

    private static Matrix readDenseSVDLIBCtext(File file, Matrix.Type type, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Matrix matrix = null;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (n == -1) {
                    n = Integer.parseInt(stringArray[i]);
                    continue;
                }
                if (n2 == -1) {
                    n2 = Integer.parseInt(stringArray[i]);
                    matrix = bl ? Matrices.create(n2, n, type) : Matrices.create(n, n2, type);
                    MATRIX_IO_LOGGER.log(Level.FINE, "created matrix of size {0} x {1}", new Object[]{n, n2});
                    continue;
                }
                int n4 = n3 / n2;
                int n5 = n3 % n2;
                double d = Double.parseDouble(stringArray[i]);
                if (bl) {
                    matrix.set(n5, n4, d);
                } else {
                    matrix.set(n4, n5, d);
                }
                ++n3;
            }
        }
        bufferedReader.close();
        return matrix;
    }

    private static Matrix readDenseSVDLIBCbinary(File file, Matrix.Type type, boolean bl) throws IOException {
        Matrix matrix;
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        Matrix matrix2 = matrix = bl ? Matrices.create(n2, n, type) : Matrices.create(n, n2, type);
        if (bl) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    matrix.set(j, i, dataInputStream.readFloat());
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    matrix.set(i, j, dataInputStream.readFloat());
                }
            }
        }
        dataInputStream.close();
        return matrix;
    }

    private static Matrix readSparseSVDLIBCbinary(File file, Matrix.Type type, boolean bl) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        MATRIX_IO_LOGGER.fine(String.format("Creating %s matrix %d rows, %d cols, %d nz%n", bl ? "transposed" : "", n, n2, n3));
        Matrix matrix = null;
        if (bl) {
            SparseDoubleVector[] sparseDoubleVectorArray = new SparseDoubleVector[n2];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n4 < n3) {
                int n7 = dataInputStream.readInt();
                int[] nArray = new int[n7];
                double[] dArray = new double[n7];
                int n8 = 0;
                while (n8 < n7) {
                    nArray[n8] = dataInputStream.readInt();
                    dArray[n8] = dataInputStream.readFloat();
                    ++n8;
                    ++n4;
                }
                CompactSparseVector compactSparseVector = new CompactSparseVector(nArray, dArray, n);
                sparseDoubleVectorArray[n6] = compactSparseVector;
                ++n6;
                ++n5;
            }
            matrix = Matrices.asSparseMatrix(Arrays.asList(sparseDoubleVectorArray));
        } else {
            matrix = Matrices.create(n, n2, type);
            int n9 = 0;
            int n10 = 0;
            while (n9 < n3) {
                int n11 = dataInputStream.readInt();
                int n12 = 0;
                while (n12 < n11) {
                    matrix.set(dataInputStream.readInt(), n10, dataInputStream.readFloat());
                    ++n12;
                    ++n9;
                }
                ++n10;
            }
        }
        dataInputStream.close();
        return matrix;
    }

    private static Matrix readMatlabSparse(File file, Matrix.Type type, boolean bl) throws IOException {
        GrowingSparseMatrix growingSparseMatrix = new GrowingSparseMatrix();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("\\s+");
            int n = Integer.parseInt(stringArray[0]) - 1;
            int n2 = Integer.parseInt(stringArray[1]) - 1;
            double d = Double.parseDouble(stringArray[2]);
            if (bl) {
                growingSparseMatrix.set(n2, n, d);
                continue;
            }
            growingSparseMatrix.set(n, n2, d);
        }
        bufferedReader.close();
        return growingSparseMatrix;
    }

    private static Matrix readSparseSVDLIBCtext(File file, Matrix.Type type, boolean bl) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("Empty input Matrix");
        }
        String[] stringArray = string.split("\\s");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        Matrix matrix = bl ? Matrices.create(n2, n, type) : Matrices.create(n, n2, type);
        for (int i = 0; i < n2 && (string = bufferedReader.readLine()) != null; ++i) {
            int n3 = Integer.parseInt(string);
            for (int j = 0; j < n3 && (string = bufferedReader.readLine()) != null; ++j) {
                String[] stringArray2 = string.split("\\s");
                int n4 = Integer.parseInt(stringArray2[0]);
                double d = Double.parseDouble(stringArray2[1]);
                if (d == 0.0) continue;
                if (bl) {
                    matrix.set(i, n4, d);
                    continue;
                }
                matrix.set(n4, i, d);
            }
        }
        bufferedReader.close();
        return matrix;
    }

    public static void writeMatrix(Matrix matrix, File file, Format format) throws IOException {
        if (matrix.rows() == 0 || matrix.columns() == 0) {
            throw new IllegalArgumentException("cannot write 0-dimensional matrix");
        }
        switch (format) {
            case DENSE_TEXT: {
                PrintWriter printWriter = new PrintWriter(file);
                for (int i = 0; i < matrix.rows(); ++i) {
                    StringBuffer stringBuffer = new StringBuffer(matrix.columns() * 5);
                    for (int j = 0; j < matrix.columns(); ++j) {
                        stringBuffer.append(matrix.get(i, j)).append(" ");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                printWriter.close();
                break;
            }
            case CLUTO_DENSE: 
            case SVDLIBC_DENSE_TEXT: {
                PrintWriter printWriter = new PrintWriter(file);
                printWriter.println(matrix.rows() + " " + matrix.columns());
                for (int i = 0; i < matrix.rows(); ++i) {
                    StringBuffer stringBuffer = new StringBuffer(32);
                    for (int j = 0; j < matrix.columns(); ++j) {
                        stringBuffer.append((float)matrix.get(i, j)).append(" ");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                printWriter.close();
                break;
            }
            case SVDLIBC_DENSE_BINARY: {
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                dataOutputStream.writeInt(matrix.rows());
                dataOutputStream.writeInt(matrix.columns());
                for (int i = 0; i < matrix.rows(); ++i) {
                    for (int j = 0; j < matrix.columns(); ++j) {
                        dataOutputStream.writeFloat((float)matrix.get(i, j));
                    }
                }
                dataOutputStream.close();
                break;
            }
            case CLUTO_SPARSE: {
                Object object;
                int n;
                PrintWriter printWriter = new PrintWriter(file);
                int n2 = 0;
                int n3 = matrix.rows();
                for (n = 0; n < n3; ++n) {
                    object = matrix.getRowVector(n);
                    if (object instanceof SparseVector) {
                        n2 += ((SparseVector)object).getNonZeroIndices().length;
                        continue;
                    }
                    for (int i = 0; i < object.length(); ++i) {
                        if (object.get(i) == 0.0) continue;
                        ++n2;
                    }
                }
                printWriter.println(matrix.rows() + " " + matrix.columns() + " " + n2);
                for (n = 0; n < n3; ++n) {
                    object = new StringBuilder(n2 / n3);
                    DoubleVector doubleVector = matrix.getRowVector(n);
                    if (doubleVector instanceof SparseVector) {
                        int[] nArray;
                        for (int n4 : nArray = ((SparseVector)((Object)doubleVector)).getNonZeroIndices()) {
                            ((StringBuilder)object).append(n4 + 1).append(" ").append(doubleVector.get(n4)).append(" ");
                        }
                    } else {
                        for (int i = 0; i < doubleVector.length(); ++i) {
                            double d = doubleVector.get(i);
                            if (d == 0.0) continue;
                            ((StringBuilder)object).append(i + 1).append(" ").append(d).append(" ");
                        }
                    }
                    printWriter.println(((StringBuilder)object).toString());
                }
                printWriter.close();
                break;
            }
            case SVDLIBC_SPARSE_TEXT: {
                int n;
                int n5;
                PrintWriter printWriter = new PrintWriter(file);
                int n6 = 0;
                int[] nArray = new int[matrix.columns()];
                for (n5 = 0; n5 < matrix.rows(); ++n5) {
                    for (n = 0; n < matrix.columns(); ++n) {
                        if (matrix.get(n5, n) == 0.0) continue;
                        ++n6;
                        int n7 = n;
                        nArray[n7] = nArray[n7] + 1;
                    }
                }
                printWriter.println(matrix.rows() + " " + matrix.columns() + " " + n6);
                for (n5 = 0; n5 < matrix.columns(); ++n5) {
                    printWriter.println(nArray[n5]);
                    if (nArray[n5] <= 0) continue;
                    for (n = 0; n < matrix.rows(); ++n) {
                        double d = matrix.get(n, n5);
                        if (d == 0.0) continue;
                        printWriter.println(n + " " + Double.valueOf(d).floatValue());
                    }
                }
                printWriter.close();
                break;
            }
            case SVDLIBC_SPARSE_BINARY: {
                int n;
                int n8;
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                int n9 = 0;
                int[] nArray = new int[matrix.columns()];
                for (n8 = 0; n8 < matrix.rows(); ++n8) {
                    for (n = 0; n < matrix.columns(); ++n) {
                        if (matrix.get(n8, n) == 0.0) continue;
                        ++n9;
                        int n10 = n;
                        nArray[n10] = nArray[n10] + 1;
                    }
                }
                dataOutputStream.writeInt(matrix.rows());
                dataOutputStream.writeInt(matrix.columns());
                dataOutputStream.writeInt(n9);
                for (n8 = 0; n8 < matrix.columns(); ++n8) {
                    dataOutputStream.writeInt(nArray[n8]);
                    if (nArray[n8] <= 0) continue;
                    for (n = 0; n < matrix.rows(); ++n) {
                        double d = matrix.get(n, n8);
                        if (d == 0.0) continue;
                        dataOutputStream.writeInt(n);
                        dataOutputStream.writeFloat((float)d);
                    }
                }
                dataOutputStream.close();
                break;
            }
            case MATLAB_SPARSE: {
                PrintWriter printWriter = new PrintWriter(file);
                int n = 0;
                int n11 = 0;
                for (int i = 0; i < matrix.rows(); ++i) {
                    for (int j = 0; j < matrix.columns(); ++j) {
                        if (matrix.get(i, j) == 0.0) continue;
                        if (j > n11) {
                            n11 = j;
                        }
                        if (i > n) {
                            n = i;
                        }
                        StringBuffer stringBuffer = new StringBuffer(32);
                        stringBuffer.append(i + 1).append(" ").append(j + 1);
                        stringBuffer.append(" ").append(matrix.get(i, j));
                        printWriter.println(stringBuffer.toString());
                    }
                }
                if (n + 1 != matrix.rows() || n11 + 1 != matrix.columns()) {
                    printWriter.println(matrix.rows() + " " + matrix.columns() + " 0");
                }
                printWriter.close();
                break;
            }
            default: {
                throw new UnsupportedOperationException("writing to " + (Object)((Object)format) + " is currently unsupported");
            }
        }
    }

    @Deprecated
    public static void writeMatrixArray(double[][] dArray, File file) throws IOException {
        if (dArray.length == 0 || dArray[0].length == 0) {
            throw new IllegalArgumentException("invalid matrix dimensions");
        }
        PrintWriter printWriter = new PrintWriter(file);
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                printWriter.print(dArray[i][j] + (j + 1 == n2 ? "\n" : " "));
            }
        }
        printWriter.close();
    }

    public static enum Format {
        DENSE_TEXT,
        MATLAB_SPARSE,
        SVDLIBC_SPARSE_TEXT,
        SVDLIBC_DENSE_TEXT,
        SVDLIBC_SPARSE_BINARY,
        SVDLIBC_DENSE_BINARY,
        CLUTO_DENSE,
        CLUTO_SPARSE;

    }
}

