/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatlabSparseMatrixBuilder
implements MatrixBuilder {
    private static final Logger LOGGER = Logger.getLogger(MatlabSparseMatrixBuilder.class.getName());
    private final File matrixFile;
    private final PrintWriter matrixWriter;
    private final boolean transposeData;
    private boolean isFinished;
    private int curColumn;

    public MatlabSparseMatrixBuilder() {
        this(MatlabSparseMatrixBuilder.getTempMatrixFile(), false);
    }

    public MatlabSparseMatrixBuilder(boolean bl) {
        this(MatlabSparseMatrixBuilder.getTempMatrixFile(), bl);
    }

    public MatlabSparseMatrixBuilder(File file) {
        this(file, false);
    }

    public MatlabSparseMatrixBuilder(File file, boolean bl) {
        this.matrixFile = file;
        this.transposeData = bl;
        this.curColumn = 0;
        this.isFinished = false;
        try {
            this.matrixWriter = new PrintWriter(this.matrixFile);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static File getTempMatrixFile() {
        File file = null;
        try {
            file = File.createTempFile("matlab-sparse-matrix", ".dat");
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        file.deleteOnExit();
        return file;
    }

    @Override
    public synchronized int addColumn(double[] dArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add rows to a MatrixBuilder that is finished");
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] == 0.0) continue;
            this.addEntry(i + 1, this.curColumn + 1, dArray[i]);
        }
        return ++this.curColumn;
    }

    @Override
    public synchronized int addColumn(SparseArray<? extends Number> sparseArray) {
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        for (int n : sparseArray.getElementIndices()) {
            this.addEntry(n + 1, this.curColumn + 1, sparseArray.get(n).doubleValue());
        }
        return ++this.curColumn;
    }

    @Override
    public synchronized int addColumn(Vector vector) {
        DoubleVector doubleVector = Vectors.asDouble(vector);
        if (this.isFinished) {
            throw new IllegalStateException("Cannot add columns to a MatrixBuilder that is finished");
        }
        if (doubleVector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)((Object)doubleVector);
            for (int n : sparseVector.getNonZeroIndices()) {
                this.addEntry(n + 1, this.curColumn + 1, doubleVector.get(n));
            }
        } else {
            for (int i = 0; i < doubleVector.length(); ++i) {
                double d = doubleVector.get(i);
                if (d == 0.0) continue;
                this.addEntry(i + 1, this.curColumn + 1, d);
            }
        }
        return ++this.curColumn;
    }

    private void addEntry(int n, int n2, double d) {
        if (this.transposeData) {
            this.matrixWriter.println(n2 + " " + n + " " + d);
        } else {
            this.matrixWriter.println(n + " " + n2 + " " + d);
        }
    }

    @Override
    public synchronized void finish() {
        if (!this.isFinished) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Finished writing matrix in MATLAB_SPARSE format with " + this.curColumn + " columns");
            }
            this.isFinished = true;
            this.matrixWriter.close();
        }
    }

    @Override
    public synchronized File getFile() {
        if (!this.isFinished) {
            throw new IllegalStateException("Cannot access matrix file until finish has been called");
        }
        return this.matrixFile;
    }

    @Override
    public MatrixIO.Format getMatrixFormat() {
        return MatrixIO.Format.MATLAB_SPARSE;
    }

    @Override
    public MatrixFile getMatrixFile() {
        return new MatrixFile(this.getFile(), this.getMatrixFormat());
    }

    @Override
    public synchronized boolean isFinished() {
        return this.isFinished;
    }
}

