/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIOException;
import edu.ucla.sspace.matrix.SimpleEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class MatlabSparseFileIterator
implements Iterator<MatrixEntry> {
    private final BufferedReader matrixFileReader;
    private MatrixEntry next;
    private int lineNo;

    public MatlabSparseFileIterator(File file) throws IOException {
        this.matrixFileReader = new BufferedReader(new FileReader(file));
        this.lineNo = 0;
        this.advance();
    }

    private void advance() throws IOException {
        String string = this.matrixFileReader.readLine();
        ++this.lineNo;
        if (string == null) {
            this.next = null;
            this.matrixFileReader.close();
        } else {
            String[] stringArray = string.split("\\s+");
            if (stringArray.length != 3) {
                throw new MatrixIOException("Incorrect number of values on line: " + this.lineNo);
            }
            int n = Integer.parseInt(stringArray[0]) - 1;
            int n2 = Integer.parseInt(stringArray[1]) - 1;
            double d = Double.parseDouble(stringArray[2]);
            this.next = new SimpleEntry(n, n2, d);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MatrixEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        MatrixEntry matrixEntry = this.next;
        try {
            this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return matrixEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }
}

