/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.common.Statistics;
import edu.ucla.sspace.matrix.BaseTransform;
import edu.ucla.sspace.matrix.GlobalTransform;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.IntegerMap;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;

public class LogEntropyTransform
extends BaseTransform {
    private static final Logger LOGGER = Logger.getLogger(LogEntropyTransform.class.getName());

    @Override
    protected GlobalTransform getTransform(File file, MatrixIO.Format format) {
        return new LogEntropyGlobalTransform(file, format);
    }

    @Override
    protected GlobalTransform getTransform(Matrix matrix) {
        return new LogEntropyGlobalTransform(matrix);
    }

    public String toString() {
        return "log-entropy";
    }

    public class LogEntropyGlobalTransform
    implements GlobalTransform {
        private double[] rowEntropy;

        public LogEntropyGlobalTransform(Matrix matrix) {
            this.rowEntropy = new double[matrix.rows()];
            int n = matrix.columns();
            if (matrix instanceof SparseMatrix) {
                SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                for (int i = 0; i < matrix.rows(); ++i) {
                    double d;
                    int[] nArray;
                    double d2 = 0.0;
                    SparseDoubleVector sparseDoubleVector = sparseMatrix.getRowVector(i);
                    for (int n2 : nArray = sparseDoubleVector.getNonZeroIndices()) {
                        d = sparseDoubleVector.get(n2);
                        d2 += d;
                    }
                    for (int n2 : nArray) {
                        d = sparseDoubleVector.get(n2);
                        double d3 = d / d2;
                        int n3 = i;
                        this.rowEntropy[n3] = this.rowEntropy[n3] + d3 * Statistics.log2(d3);
                    }
                    this.rowEntropy[i] = 1.0 + this.rowEntropy[i] / Statistics.log2(n);
                }
            } else {
                for (int i = 0; i < matrix.rows(); ++i) {
                    int n4;
                    double d = 0.0;
                    for (n4 = 0; n4 < matrix.columns(); ++n4) {
                        d += matrix.get(i, n4);
                    }
                    for (n4 = 0; n4 < matrix.columns(); ++n4) {
                        double d4 = matrix.get(i, n4);
                        double d5 = d4 / d;
                        int n5 = i;
                        this.rowEntropy[n5] = this.rowEntropy[n5] + d5 * Statistics.log2(d5);
                    }
                    this.rowEntropy[i] = 1.0 + this.rowEntropy[i] / Statistics.log2(n);
                }
            }
        }

        public LogEntropyGlobalTransform(File file, MatrixIO.Format format) {
            Double d;
            MatrixEntry matrixEntry;
            Iterator<MatrixEntry> iterator;
            IntegerMap<Double> integerMap = new IntegerMap<Double>();
            try {
                iterator = MatrixIO.getMatrixFileIterator(file, format);
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                matrixEntry = iterator.next();
                d = (Double)integerMap.get((Object)matrixEntry.row());
                integerMap.put(matrixEntry.row(), Double.valueOf(d == null ? matrixEntry.value() : d + matrixEntry.value()));
                if (matrixEntry.row() >= n2) {
                    n2 = matrixEntry.row() + 1;
                }
                if (matrixEntry.column() < n) continue;
                n = matrixEntry.column() + 1;
            }
            this.rowEntropy = new double[n2];
            try {
                iterator = MatrixIO.getMatrixFileIterator(file, format);
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
            while (iterator.hasNext()) {
                matrixEntry = iterator.next();
                d = (Double)integerMap.get((Object)matrixEntry.row());
                double d2 = d == null ? 0.0 : d;
                double d3 = matrixEntry.value() / d2;
                int n3 = matrixEntry.row();
                this.rowEntropy[n3] = this.rowEntropy[n3] + d3 * Statistics.log2(d3);
            }
            for (int i = 0; i < n2; ++i) {
                this.rowEntropy[i] = 1.0 + this.rowEntropy[i] / Statistics.log2(n);
            }
        }

        @Override
        public double transform(int n, int n2, double d) {
            return Statistics.log2_1p(d) * this.rowEntropy[n];
        }
    }
}

