/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.logging.Logger;

public class LocalityPreservingProjection {
    private static final Logger LOGGER = Logger.getLogger(LocalityPreservingProjection.class.getName());
    private static final String SR_LPP_M = "%% This code requires the SR-LPP implementation by Deng Cai (dengcai AT\n%% gmail.com) available at\n%% http://www.zjucadcg.cn/dengcai/SR/index.html\n\n%% Load the data matrix from file\nTmp = load('%s','-ascii');\ndata = spconvert(Tmp);\n%% Remove the raw data file to save space\nclear Tmp;\n\n%% Load the affinity matrix from file\nTmp = load('%s','-ascii');\nW = spconvert(Tmp);\n%% Remove the raw data file to save space\nclear Tmp;\n\n%% If 0, all of the dimensions in the adj. matrix are used\nDim = %d\n\noptions = [];\noptions.W = W;\noptions.ReguAlpha = 0.01;\noptions.ReguType = 'Ridge';\noptions.ReducedDim = Dim;\n%% Call the SR code\n[eigvector] = SR_caller(options, data);\n[nSmp,nFea] = size(data);\nif size(eigvector,1) == nFea + 1\n    Projection = [data ones(nSmp,1)]*eigvector;\nelse\n    Projection = data*eigvector;\nend\n%% Save the projection as a matrix\n%s\nfprintf(1,'Finished\\n');\n\n";
    private static final String LPP_M = "%% LPP code based on the Matlab implementation by Deng Cai (dengcai2 AT\n%% cs.uiuc.edu) available at\n%% http://www.cs.uiuc.edu/homes/dengcai2/Data/code/LPP.m\n\n%% Load the data matrix from file\nTmp = load('%s','-ascii');\ndata = spconvert(Tmp);\n%% Remove the raw data file to save space\nclear Tmp;\n[nSmp,nFea] = size(data);\n%% Subtract out the mean fromm the data.  See page 7 of the LPI paper\nprintf('Subtracting out the mean\\n');\nif issparse(data)\n    data = full(data);\nend\nsampleMean = mean(data);\ndata = (data - repmat(sampleMean,nSmp,1));\n\n%% Load the affinity matrix from file\nTmp = load('%s','-ascii');\nW = spconvert(Tmp);\n%% Remove the raw data file to save space\nclear Tmp;\n\n%% If 0, all of the dimensions in the adj. matrix are used\nDim = %d\n\noptions = [];\n\nD = full(sum(W,2));\n%%options.ReguAlpha = options.ReguAlpha*sum(D)/length(D);\nD = sparse(1:nSmp,1:nSmp,D,nSmp,nSmp);\n\nprintf('Computing D prime\\n');\nDPrime = data'*D*data;\nDPrime = max(DPrime,DPrime');\n\nprintf('Computing W prime\\n');\nWPrime = data'*W*data;\nWPrime = max(WPrime,WPrime');\n\ndimMatrix = size(WPrime,2);\n\nif Dim > dimMatrix\n    Dim = dimMatrix;\nend\n\n%% Before using eigs, check whether the affinity matrix is positive and definite\n%%printf('Testing if DPrime is pos. def.\\n');\n%%isposdef = true;\n%%for i=1:length(DPrime)\n%%     if ( det( DPrime(1:i, 1:i) ) <= 0 )\n%%          isposdef = false;\n%%          break;\n%%      end\n%%end\n\n%%if (isposdef & dimMatrix > 1000 & Dim < dimMatrix/10) | (dimMatrix > 500 & Dim < dimMatrix/20) | (dimMatrix > 250 & Dim < dimMatrix/30)\n%%    bEigs = 1;\n%%else\n    bEigs = 0;\n%%end\n\n\nprintf('Computing Eigenvectors\\n');\nif bEigs\n    %%disp('using eigs to speed up!');\n    [eigvector, eigvalue] = eigs(WPrime,DPrime,Dim,'la');\n    eigvalue = diag(eigvalue);\nelse\n    [eigvector, eigvalue] = eig(WPrime,DPrime);\n    eigvalue = diag(eigvalue);\n\n    [junk, index] = sort(-eigvalue);\n    eigvalue = eigvalue(index);\n    eigvector = eigvector(:,index);\n\n    if Dim < size(eigvector,2)\n        eigvector = eigvector(:, 1:Dim);\n        eigvalue = eigvalue(1:Dim);\n    end\nend\n\nfor i = 1:size(eigvector,2)\n    eigvector(:,i) = eigvector(:,i)./norm(eigvector(:,i));\nend\n\neigIdx = find(eigvalue < 1e-3);\neigvalue (eigIdx) = [];\neigvector(:,eigIdx) = [];\n\n%% Compute the projection\nprintf('Computing projection matrix\\n');\nprojection = data*eigvector;\n\n%% Save the projection as a matrix\n%s\nprintf('Finished\\n');\n";

    private LocalityPreservingProjection() {
    }

    public static MatrixFile project(MatrixFile matrixFile, MatrixFile matrixFile2, int n) {
        try {
            File file = File.createTempFile("lcc-output-matrix", ".dat");
            LocalityPreservingProjection.execute(matrixFile.getFile(), matrixFile2.getFile(), n, file);
            return new MatrixFile(file, MatrixIO.Format.DENSE_TEXT);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static Matrix project(Matrix matrix, MatrixFile matrixFile, int n) {
        try {
            return LocalityPreservingProjection.execute(matrix, matrixFile, n);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public static Matrix project(Matrix matrix, Matrix matrix2, int n) {
        try {
            File file = File.createTempFile("affinity-matrix", ".dat");
            MatrixIO.writeMatrix(matrix2, file, MatrixIO.Format.MATLAB_SPARSE);
            return LocalityPreservingProjection.execute(matrix, new MatrixFile(file, MatrixIO.Format.MATLAB_SPARSE), n);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private static Matrix execute(Matrix matrix, MatrixFile matrixFile, int n) throws IOException {
        File file = File.createTempFile("lpp-input-data-matrix", ".dat");
        file.deleteOnExit();
        MatrixIO.writeMatrix(matrix, file, MatrixIO.Format.MATLAB_SPARSE);
        File file2 = File.createTempFile("lpp-output-matrix", ".dat");
        LocalityPreservingProjection.execute(file, matrixFile.getFile(), n, file2);
        return MatrixIO.readMatrix(file2, MatrixIO.Format.DENSE_TEXT);
    }

    private static void execute(File file, File file2, int n, File file3) throws IOException {
        if (LocalityPreservingProjection.isMatlabAvailable()) {
            LocalityPreservingProjection.invokeMatlab(file, file2, n, file3);
        } else if (LocalityPreservingProjection.isOctaveAvailable()) {
            LocalityPreservingProjection.invokeOctave(file, file2, n, file3);
        } else {
            throw new IllegalStateException("Cannot find Matlab or Octave to invoke LPP");
        }
    }

    private static void invokeMatlab(File file, File file2, int n, File file3) throws IOException {
        String string = "matlab -nodisplay -nosplash -nojvm";
        LOGGER.fine(string);
        Process process = Runtime.getRuntime().exec(string);
        String string2 = "save " + file3.getAbsolutePath() + " projection -ASCII\n";
        String string3 = String.format(SR_LPP_M, file.getAbsolutePath(), file2.getAbsolutePath(), n, string2);
        PrintWriter printWriter = new PrintWriter(process.getOutputStream());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        printWriter.println(string3);
        printWriter.close();
        StringBuilder stringBuilder = new StringBuilder("Matlab LPP output:\n");
        String string4 = null;
        while ((string4 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string4).append("\n");
            if (!string4.equals("Finished")) continue;
            process.destroy();
        }
        LOGGER.fine(stringBuilder.toString());
        int n2 = -1;
        try {
            n2 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        LOGGER.fine("Octave LPP exit status: " + n2);
        if (n2 != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string5 = null;
            while ((string5 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string5).append("\n");
            }
            throw new IllegalStateException("Matlab LPP did not finish normally: " + stringBuilder2);
        }
    }

    private static void invokeOctave(File file, File file2, int n, File file3) throws IOException {
        File file4 = File.createTempFile("octave-LPP", ".m");
        String string = "save(\"-ascii\", \"" + file3.getAbsolutePath() + "\", \"projection\");\n";
        String string2 = null;
        try {
            string2 = String.format(SR_LPP_M, file.getAbsolutePath(), file2.getAbsolutePath(), n, string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        PrintWriter printWriter = new PrintWriter(file4);
        printWriter.println(string2);
        printWriter.close();
        String string3 = "octave " + file4.getAbsolutePath();
        LOGGER.fine(string3);
        Process process = Runtime.getRuntime().exec(string3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        StringBuilder stringBuilder = new StringBuilder("Octave LPP output:\n");
        String string4 = null;
        while ((string4 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string4).append("\n");
        }
        LOGGER.fine(stringBuilder.toString());
        int n2 = -1;
        try {
            n2 = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        LOGGER.fine("Octave LPP exit status: " + n2);
        if (n2 != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string5 = null;
            while ((string5 = bufferedReader2.readLine()) != null) {
                stringBuilder2.append(string5).append("\n");
            }
            throw new IllegalStateException("Octave LPP did not finish normally: " + stringBuilder2);
        }
    }

    private static boolean isOctaveAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("octave -v");
            process.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static boolean isMatlabAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("matlab -h");
            process.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

