/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.util.ArrayList;
import java.util.List;

class ListMatrix<T extends DoubleVector>
implements Matrix {
    protected List<T> vectors;
    protected int columns;

    public ListMatrix(List<T> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Must provide at least one vector");
        }
        this.vectors = new ArrayList<T>(list.size());
        this.columns = ((DoubleVector)list.get(0)).length();
        for (DoubleVector doubleVector : list) {
            if (doubleVector.length() != this.columns) {
                throw new IllegalArgumentException("Cannot create ragged matrix from list of vectors");
            }
            this.vectors.add(doubleVector);
        }
    }

    public ListMatrix(List<T> list, int n) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("Must provide at least one vector");
        }
        this.vectors = new ArrayList<T>(list);
        this.columns = n;
    }

    @Override
    public double get(int n, int n2) {
        return ((DoubleVector)this.vectors.get(n)).get(n2);
    }

    @Override
    public double[] getColumn(int n) {
        int n2 = 0;
        double[] dArray = new double[this.vectors.size()];
        for (DoubleVector doubleVector : this.vectors) {
            dArray[n2++] = doubleVector.get(n);
        }
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        int n2 = 0;
        DenseVector denseVector = new DenseVector(this.vectors.size());
        for (DoubleVector doubleVector : this.vectors) {
            denseVector.set(n2++, doubleVector.get(n));
        }
        return denseVector;
    }

    @Override
    public double[] getRow(int n) {
        return ((DoubleVector)this.vectors.get(n)).toArray();
    }

    public T getRowVector(int n) {
        return (T)((DoubleVector)this.vectors.get(n));
    }

    @Override
    public int columns() {
        return this.columns;
    }

    @Override
    public int rows() {
        return this.vectors.size();
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.vectors.size()][this.columns];
        int n = 0;
        for (DoubleVector doubleVector : this.vectors) {
            for (int i = 0; i < doubleVector.length(); ++i) {
                dArray[n][i] = doubleVector.get(i);
            }
            ++n;
        }
        return dArray;
    }

    @Override
    public void set(int n, int n2, double d) {
        DoubleVector doubleVector = (DoubleVector)this.vectors.get(n);
        doubleVector.set(n2, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        int n2 = 0;
        for (DoubleVector doubleVector : this.vectors) {
            doubleVector.set(n, dArray[n2++]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        int n2 = 0;
        for (DoubleVector doubleVector2 : this.vectors) {
            doubleVector2.set(n, doubleVector.get(n2++));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        DoubleVector doubleVector = (DoubleVector)this.vectors.get(n);
        for (int i = 0; i < dArray.length; ++i) {
            doubleVector.set(i, dArray[i]);
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        DoubleVector doubleVector2 = (DoubleVector)this.vectors.get(n);
        for (int i = 0; i < doubleVector.length(); ++i) {
            doubleVector2.set(i, doubleVector.get(i));
        }
    }
}

