/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.HashMap;
import java.util.Map;

public class GrowingSparseMatrix
implements SparseMatrix {
    private int rows;
    private int cols;
    private final Map<Integer, CompactSparseVector> rowToColumns;

    public GrowingSparseMatrix() {
        this(0, 0);
    }

    public GrowingSparseMatrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.rowToColumns = new HashMap<Integer, CompactSparseVector>();
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        CompactSparseVector compactSparseVector = this.rowToColumns.get(n);
        return compactSparseVector == null ? 0.0 : compactSparseVector.get(n2);
    }

    @Override
    public double[] getColumn(int n) {
        double[] dArray = new double[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            dArray[i] = this.get(i, n);
        }
        return dArray;
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.rows);
        for (int i = 0; i < this.rows; ++i) {
            double d = this.get(i, n);
            if (d == 0.0) continue;
            sparseHashDoubleVector.set(i, d);
        }
        return sparseHashDoubleVector;
    }

    @Override
    public double[] getRow(int n) {
        return GrowingSparseMatrix.toArray(this.rowToColumns.get(n), this.cols);
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        SparseDoubleVector sparseDoubleVector = this.rowToColumns.get(n);
        return sparseDoubleVector != null ? Vectors.subview(sparseDoubleVector, 0, this.cols) : new CompactSparseVector(this.cols);
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public void set(int n, int n2, double d) {
        CompactSparseVector compactSparseVector;
        this.checkIndices(n, n2);
        if (n + 1 > this.rows) {
            this.rows = n + 1;
        }
        if (n2 + 1 > this.cols) {
            this.cols = n2 + 1;
        }
        if ((compactSparseVector = this.rowToColumns.get(n)) == null) {
            compactSparseVector = new CompactSparseVector();
            this.rowToColumns.put(n, compactSparseVector);
        }
        compactSparseVector.set(n2, d);
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        for (int i = 0; i < this.rows(); ++i) {
            this.set(i, n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        CompactSparseVector compactSparseVector;
        this.checkIndices(n, dArray.length - 1);
        if (this.cols <= dArray.length) {
            this.cols = dArray.length;
        }
        if ((compactSparseVector = this.rowToColumns.get(n)) == null) {
            compactSparseVector = new CompactSparseVector();
            this.rowToColumns.put(n, compactSparseVector);
        }
        for (int i = 0; i < this.cols; ++i) {
            double d = dArray[i];
            compactSparseVector.set(i, d);
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        CompactSparseVector compactSparseVector;
        this.checkIndices(n, doubleVector.length() - 1);
        if (this.cols <= doubleVector.length()) {
            this.cols = doubleVector.length();
        }
        if ((compactSparseVector = this.rowToColumns.get(n)) == null) {
            compactSparseVector = new CompactSparseVector();
            this.rowToColumns.put(n, compactSparseVector);
        }
        Vectors.copy(compactSparseVector, doubleVector);
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            dArray[i] = GrowingSparseMatrix.toArray(this.rowToColumns.get(i), this.cols);
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private static double[] toArray(DoubleVector doubleVector, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = doubleVector.get(i);
        }
        return dArray;
    }
}

