/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.MatrixEntry;
import edu.ucla.sspace.matrix.SimpleEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

class DenseTextFileIterator
implements Iterator<MatrixEntry> {
    private final BufferedReader reader;
    private MatrixEntry next;
    private int rows;
    private int cols;
    private int curCol;
    private int curRow;
    private String[] curLine;

    public DenseTextFileIterator(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
        this.curLine = this.reader.readLine().split("\\s+");
        this.curCol = 0;
        this.curRow = 0;
        this.next = this.advance();
    }

    private MatrixEntry advance() throws IOException {
        if (this.curLine == null) {
            return null;
        }
        if (this.curCol >= this.curLine.length) {
            this.curCol = 0;
            ++this.curRow;
            String string = this.reader.readLine();
            if (string == null) {
                this.curLine = null;
                this.reader.close();
                return null;
            }
            this.curLine = string.split("\\s+");
        }
        return new SimpleEntry(this.curRow, this.curCol, Double.parseDouble(this.curLine[this.curCol++]));
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MatrixEntry next() {
        if (this.next == null) {
            throw new NoSuchElementException("No futher entries");
        }
        MatrixEntry matrixEntry = this.next;
        try {
            this.next = this.advance();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return matrixEntry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from file");
    }
}

