/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.CellMaskedMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.vector.MaskedSparseDoubleVectorView;
import edu.ucla.sspace.vector.SparseDoubleVector;
import java.util.HashMap;
import java.util.Map;

public class CellMaskedSparseMatrix
extends CellMaskedMatrix
implements SparseMatrix {
    private final SparseMatrix matrix;
    private final int[] rowMaskMap;
    private final Map<Integer, Integer> reverseRowMaskMap;
    private final int[] colMaskMap;
    private final Map<Integer, Integer> reverseColMaskMap;

    public CellMaskedSparseMatrix(SparseMatrix sparseMatrix, int[] nArray, int[] nArray2) {
        super(sparseMatrix, nArray, nArray2);
        int n;
        this.matrix = sparseMatrix;
        this.rowMaskMap = nArray;
        this.colMaskMap = nArray2;
        this.reverseRowMaskMap = new HashMap<Integer, Integer>();
        for (n = 0; n < nArray.length; ++n) {
            this.reverseRowMaskMap.put(nArray[n], n);
        }
        this.reverseColMaskMap = new HashMap<Integer, Integer>();
        for (n = 0; n < nArray2.length; ++n) {
            this.reverseColMaskMap.put(nArray2[n], n);
        }
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        n = this.getIndexFromMap(this.rowMaskMap, n);
        return new MaskedSparseDoubleVectorView(this.matrix.getRowVector(n), this.colMaskMap, this.reverseColMaskMap);
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        n = this.getIndexFromMap(this.colMaskMap, n);
        return new MaskedSparseDoubleVectorView(this.matrix.getColumnVector(n), this.rowMaskMap, this.reverseRowMaskMap);
    }
}

