/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.matrix.SparseMatrix;
import edu.ucla.sspace.util.IntegerMap;
import edu.ucla.sspace.vector.AtomicSparseVector;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.SparseHashDoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AtomicGrowingSparseMatrix
implements AtomicMatrix,
SparseMatrix {
    private Lock rowReadLock;
    private Lock rowWriteLock;
    private Lock denseArrayReadLock;
    private Lock denseArrayWriteLock;
    private AtomicInteger rows = new AtomicInteger(0);
    private AtomicInteger cols = new AtomicInteger(0);
    private final Map<Integer, AtomicSparseVector> sparseMatrix = new IntegerMap<AtomicSparseVector>();

    public AtomicGrowingSparseMatrix() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.rowReadLock = reentrantReadWriteLock.readLock();
        this.rowWriteLock = reentrantReadWriteLock.writeLock();
        reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.denseArrayReadLock = reentrantReadWriteLock.readLock();
        this.denseArrayWriteLock = reentrantReadWriteLock.writeLock();
    }

    @Override
    public double addAndGet(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicSparseVector atomicSparseVector = this.getRow(n, n2, true);
        return atomicSparseVector.addAndGet(n2, d);
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public int columns() {
        return this.cols.get();
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        AtomicSparseVector atomicSparseVector = this.getRow(n, n2, false);
        return atomicSparseVector == null ? 0.0 : atomicSparseVector.get(n2);
    }

    @Override
    public double getAndAdd(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicSparseVector atomicSparseVector = this.getRow(n, n2, true);
        return atomicSparseVector.getAndAdd(n2, d);
    }

    @Override
    public double[] getColumn(int n) {
        this.checkIndices(0, n);
        this.rowReadLock.lock();
        double[] dArray = new double[this.rows.get()];
        for (int i = 0; i < this.rows.get(); ++i) {
            dArray[i] = this.get(i, n);
        }
        this.rowReadLock.unlock();
        return dArray;
    }

    @Override
    public SparseDoubleVector getColumnVector(int n) {
        this.checkIndices(0, n);
        this.rowReadLock.lock();
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.rows.get());
        for (int i = 0; i < this.rows.get(); ++i) {
            AtomicSparseVector atomicSparseVector = this.getRow(i, -1, false);
            double d = 0.0;
            if (atomicSparseVector == null || (d = atomicSparseVector.get(n)) == 0.0) continue;
            sparseHashDoubleVector.set(i, d);
        }
        this.rowReadLock.unlock();
        return sparseHashDoubleVector;
    }

    public SparseDoubleVector getColumnVectorUnsafe(int n) {
        this.checkIndices(0, n);
        SparseHashDoubleVector sparseHashDoubleVector = new SparseHashDoubleVector(this.rows.get());
        for (int i = 0; i < this.rows.get(); ++i) {
            AtomicSparseVector atomicSparseVector = this.getRow(i, -1, false);
            double d = 0.0;
            if (atomicSparseVector == null || (d = atomicSparseVector.get(n)) == 0.0) continue;
            sparseHashDoubleVector.set(i, d);
        }
        return sparseHashDoubleVector;
    }

    @Override
    public double[] getRow(int n) {
        this.checkIndices(n, 0);
        AtomicSparseVector atomicSparseVector = this.getRow(n, -1, false);
        return atomicSparseVector == null ? new double[this.cols.get()] : AtomicGrowingSparseMatrix.toArray(atomicSparseVector, this.cols.get());
    }

    private AtomicSparseVector getRow(int n, int n2, boolean bl) {
        this.rowReadLock.lock();
        AtomicSparseVector atomicSparseVector = this.sparseMatrix.get(n);
        if (n2 >= this.cols.get()) {
            this.cols.set(n2 + 1);
        }
        this.rowReadLock.unlock();
        if (atomicSparseVector == null && bl) {
            this.rowWriteLock.lock();
            atomicSparseVector = this.sparseMatrix.get(n);
            if (atomicSparseVector == null) {
                atomicSparseVector = new AtomicSparseVector(new CompactSparseVector());
                if (n >= this.rows.get()) {
                    this.rows.set(n + 1);
                }
                this.sparseMatrix.put(n, atomicSparseVector);
            }
            this.rowWriteLock.unlock();
        }
        return atomicSparseVector;
    }

    @Override
    public SparseDoubleVector getRowVector(int n) {
        AtomicSparseVector atomicSparseVector = this.getRow(n, -1, false);
        return atomicSparseVector == null ? new CompactSparseVector(this.cols.get()) : Vectors.subview(atomicSparseVector, 0, this.cols.get());
    }

    public SparseDoubleVector getRowVectorUnsafe(int n) {
        AtomicSparseVector atomicSparseVector = this.sparseMatrix.get(n);
        return atomicSparseVector == null ? new CompactSparseVector(this.cols.get()) : Vectors.immutable(Vectors.subview(atomicSparseVector.getVector(), 0, this.cols.get()));
    }

    @Override
    public int rows() {
        return this.rows.get();
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicSparseVector atomicSparseVector = this.getRow(n, n2, true);
        this.denseArrayReadLock.lock();
        atomicSparseVector.set(n2, d);
        this.denseArrayReadLock.unlock();
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.checkIndices(0, n);
        for (int i = 0; i < this.rows.get(); ++i) {
            this.set(i, n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.checkIndices(0, n);
        for (int i = 0; i < this.rows.get(); ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.checkIndices(n, 0);
        AtomicSparseVector atomicSparseVector = this.getRow(n, dArray.length - 1, true);
        this.denseArrayReadLock.lock();
        for (int i = 0; i < dArray.length; ++i) {
            atomicSparseVector.set(i, dArray[i]);
        }
        this.denseArrayReadLock.unlock();
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.checkIndices(n, 0);
        AtomicSparseVector atomicSparseVector = this.getRow(n, doubleVector.length() - 1, true);
        this.denseArrayReadLock.lock();
        Vectors.copy(atomicSparseVector, doubleVector);
        this.denseArrayReadLock.unlock();
    }

    @Override
    public double[][] toDenseArray() {
        this.rowWriteLock.lock();
        this.denseArrayWriteLock.lock();
        int n = this.cols.get();
        double[][] dArray = new double[this.rows.get()][n];
        for (Map.Entry<Integer, AtomicSparseVector> entry : this.sparseMatrix.entrySet()) {
            dArray[entry.getKey().intValue()] = AtomicGrowingSparseMatrix.toArray(entry.getValue(), n);
        }
        this.denseArrayWriteLock.unlock();
        this.rowWriteLock.unlock();
        return dArray;
    }

    private static double[] toArray(DoubleVector doubleVector, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = doubleVector.get(i);
        }
        return dArray;
    }
}

