/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.AtomicMatrix;
import edu.ucla.sspace.util.IntegerMap;
import edu.ucla.sspace.vector.AtomicVector;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vectors;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AtomicGrowingMatrix
implements AtomicMatrix {
    private Lock rowReadLock;
    private Lock rowWriteLock;
    private Lock denseArrayReadLock;
    private Lock denseArrayWriteLock;
    private AtomicInteger rows = new AtomicInteger(0);
    private AtomicInteger cols = new AtomicInteger(0);
    private final Map<Integer, AtomicVector> sparseMatrix = new IntegerMap<AtomicVector>();

    public AtomicGrowingMatrix() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.rowReadLock = reentrantReadWriteLock.readLock();
        this.rowWriteLock = reentrantReadWriteLock.writeLock();
        reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.denseArrayReadLock = reentrantReadWriteLock.readLock();
        this.denseArrayWriteLock = reentrantReadWriteLock.writeLock();
    }

    @Override
    public double addAndGet(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicVector atomicVector = this.getRow(n, n2, true);
        return atomicVector.addAndGet(n2, d);
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public int columns() {
        return this.cols.get();
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        AtomicVector atomicVector = this.getRow(n, n2, false);
        return atomicVector == null ? 0.0 : atomicVector.get(n2);
    }

    @Override
    public double getAndAdd(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicVector atomicVector = this.getRow(n, n2, true);
        return atomicVector.getAndAdd(n2, d);
    }

    @Override
    public double[] getColumn(int n) {
        this.checkIndices(0, n);
        this.rowReadLock.lock();
        double[] dArray = new double[this.rows.get()];
        for (int i = 0; i < this.rows.get(); ++i) {
            dArray[i] = this.get(i, n);
        }
        this.rowReadLock.unlock();
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        this.checkIndices(0, n);
        this.rowReadLock.lock();
        DenseVector denseVector = new DenseVector(this.rows.get());
        for (int i = 0; i < this.rows.get(); ++i) {
            double d = this.get(i, n);
            if (d == 0.0) continue;
            denseVector.set(i, d);
        }
        this.rowReadLock.unlock();
        return denseVector;
    }

    public DoubleVector getColumnVectorUnsafe(int n) {
        this.checkIndices(0, n);
        DenseVector denseVector = new DenseVector(this.rows.get());
        for (int i = 0; i < this.rows.get(); ++i) {
            AtomicVector atomicVector = this.getRow(i, -1, false);
            double d = 0.0;
            if (atomicVector == null || (d = atomicVector.get(n)) == 0.0) continue;
            denseVector.set(i, d);
        }
        return denseVector;
    }

    @Override
    public double[] getRow(int n) {
        this.checkIndices(n, 0);
        AtomicVector atomicVector = this.getRow(n, -1, false);
        return atomicVector == null ? new double[this.cols.get()] : AtomicGrowingMatrix.toArray(atomicVector, this.cols.get());
    }

    private AtomicVector getRow(int n, int n2, boolean bl) {
        this.rowReadLock.lock();
        AtomicVector atomicVector = this.sparseMatrix.get(n);
        this.rowReadLock.unlock();
        if (atomicVector == null && bl) {
            this.rowWriteLock.lock();
            atomicVector = this.sparseMatrix.get(n);
            if (atomicVector == null) {
                atomicVector = new AtomicVector(new CompactSparseVector());
                if (n >= this.rows.get()) {
                    this.rows.set(n + 1);
                }
                if (n2 >= this.cols.get()) {
                    this.cols.set(n2 + 1);
                }
                this.sparseMatrix.put(n, atomicVector);
            }
            this.rowWriteLock.unlock();
        }
        return atomicVector;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        AtomicVector atomicVector = this.getRow(n, -1, false);
        return atomicVector == null ? new CompactSparseVector(this.cols.get()) : Vectors.subview(atomicVector, 0, this.cols.get());
    }

    public DoubleVector getRowVectorUnsafe(int n) {
        AtomicVector atomicVector = this.sparseMatrix.get(n);
        return atomicVector == null ? new CompactSparseVector(this.cols.get()) : Vectors.immutable(Vectors.subview(atomicVector.getVector(), 0, this.cols.get()));
    }

    @Override
    public int rows() {
        return this.rows.get();
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        AtomicVector atomicVector = this.getRow(n, n2, true);
        this.denseArrayReadLock.lock();
        atomicVector.set(n2, d);
        this.denseArrayReadLock.unlock();
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.checkIndices(0, n);
        for (int i = 0; i < this.rows.get(); ++i) {
            this.set(i, n, dArray[i]);
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.checkIndices(0, n);
        for (int i = 0; i < this.rows.get(); ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.checkIndices(n, 0);
        AtomicVector atomicVector = this.getRow(n, dArray.length - 1, true);
        this.denseArrayReadLock.lock();
        for (int i = 0; i < dArray.length; ++i) {
            atomicVector.set(i, dArray[i]);
        }
        this.denseArrayReadLock.unlock();
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.checkIndices(n, 0);
        AtomicVector atomicVector = this.getRow(n, doubleVector.length() - 1, true);
        this.denseArrayReadLock.lock();
        Vectors.copy(atomicVector, doubleVector);
        this.denseArrayReadLock.unlock();
    }

    @Override
    public double[][] toDenseArray() {
        this.rowWriteLock.lock();
        this.denseArrayWriteLock.lock();
        int n = this.cols.get();
        double[][] dArray = new double[this.rows.get()][n];
        for (Map.Entry<Integer, AtomicVector> entry : this.sparseMatrix.entrySet()) {
            dArray[entry.getKey().intValue()] = AtomicGrowingMatrix.toArray(entry.getValue(), n);
        }
        this.denseArrayWriteLock.unlock();
        this.rowWriteLock.unlock();
        return dArray;
    }

    private static double[] toArray(DoubleVector doubleVector, int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = doubleVector.get(i);
        }
        return dArray;
    }
}

