/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;

public class ArrayMatrix
implements Matrix,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int rows;
    private final int cols;
    private final double[] matrix;

    public ArrayMatrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.matrix = new double[n * n2];
    }

    public ArrayMatrix(double[][] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("invalid matrix dimensions");
        }
        this.rows = dArray.length;
        if (this.rows < 1) {
            throw new IllegalArgumentException("invalid matrix dimensions");
        }
        this.cols = dArray[0].length;
        if (this.cols < 1) {
            throw new IllegalArgumentException("invalid matrix dimensions");
        }
        this.matrix = new double[this.rows * this.cols];
        for (int i = 0; i < this.rows; ++i) {
            if (this.cols != dArray[i].length) {
                throw new IllegalArgumentException("invalid matrix dimensions");
            }
            for (int j = 0; j < this.cols; ++j) {
                this.set(i, j, dArray[i][j]);
            }
        }
    }

    public ArrayMatrix(int n, int n2, double[] dArray) {
        this.rows = n;
        this.cols = n2;
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("invalid matrix dimensions");
        }
        if (dArray == null) {
            throw new NullPointerException("provided matrix cannot be null");
        }
        if (dArray.length != n * n2) {
            throw new IllegalArgumentException("provided matrix is wrong size");
        }
        this.matrix = dArray;
    }

    private void checkIndices(int n, int n2) {
        if (n < 0 || n >= this.rows) {
            throw new ArrayIndexOutOfBoundsException("row: " + n);
        }
        if (n2 < 0 || n2 >= this.cols) {
            throw new ArrayIndexOutOfBoundsException("column: " + n2);
        }
    }

    @Override
    public double get(int n, int n2) {
        this.checkIndices(n, n2);
        int n3 = this.getIndex(n, n2);
        return this.matrix[n3];
    }

    @Override
    public double[] getColumn(int n) {
        this.checkIndices(0, n);
        double[] dArray = new double[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            dArray[i] = this.get(i, n);
        }
        return dArray;
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        return new DenseVector(this.getColumn(n));
    }

    @Override
    public double[] getRow(int n) {
        this.checkIndices(n, 0);
        double[] dArray = new double[this.cols];
        int n2 = this.getIndex(n, 0);
        for (int i = 0; i < this.cols; ++i) {
            dArray[i] = this.matrix[n2++];
        }
        return dArray;
    }

    @Override
    public DoubleVector getRowVector(int n) {
        this.checkIndices(n, 0);
        DenseVector denseVector = new DenseVector(this.cols);
        int n2 = this.getIndex(n, 0);
        for (int i = 0; i < this.cols; ++i) {
            denseVector.set(i, this.matrix[n2++]);
        }
        return denseVector;
    }

    @Override
    public int columns() {
        return this.cols;
    }

    private int getIndex(int n, int n2) {
        return n * this.cols + n2;
    }

    @Override
    public void set(int n, int n2, double d) {
        this.checkIndices(n, n2);
        int n3 = this.getIndex(n, n2);
        this.matrix[n3] = d;
    }

    @Override
    public void setColumn(int n, double[] dArray) {
        this.checkIndices(dArray.length - 1, n);
        for (int i = 0; i < this.rows; ++i) {
            this.matrix[this.getIndex((int)i, (int)n)] = dArray[n];
        }
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        this.checkIndices(doubleVector.length() - 1, n);
        for (int i = 0; i < this.rows; ++i) {
            this.matrix[this.getIndex((int)i, (int)n)] = doubleVector.get(i);
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.checkIndices(n, dArray.length - 1);
        for (int i = 0; i < this.cols; ++i) {
            this.matrix[this.getIndex((int)n, (int)i)] = dArray[i];
        }
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        this.checkIndices(n, doubleVector.length() - 1);
        for (int i = 0; i < this.cols; ++i) {
            this.matrix[this.getIndex((int)n, (int)i)] = doubleVector.get(i);
        }
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows][this.cols];
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                dArray[i][j] = this.matrix[n++];
            }
        }
        return dArray;
    }

    @Override
    public int rows() {
        return this.rows;
    }
}

