/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.matrix;

import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import edu.ucla.sspace.vector.Vectors;

public abstract class AbstractMatrix
implements Matrix {
    @Override
    public abstract int columns();

    public boolean equals(Object object) {
        Matrix matrix;
        if (object instanceof Matrix && (matrix = (Matrix)object).rows() == this.rows() && matrix.columns() == this.columns()) {
            for (int i = 0; i < this.rows(); ++i) {
                if (this.getRowVector(i).equals(matrix.getRowVector(i))) continue;
                return false;
            }
        }
        return false;
    }

    @Override
    public double get(int n, int n2) {
        return this.getRowVector(n).get(n2);
    }

    @Override
    public double[] getColumn(int n) {
        return this.getColumnVector(n).toArray();
    }

    @Override
    public DoubleVector getColumnVector(int n) {
        DenseVector denseVector = new DenseVector(this.rows());
        for (int i = 0; i < this.rows(); ++i) {
            denseVector.set(i, this.getRowVector(i).get(n));
        }
        return denseVector;
    }

    @Override
    public double[] getRow(int n) {
        return this.getRowVector(n).toArray();
    }

    @Override
    public abstract DoubleVector getRowVector(int var1);

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.rows(); ++i) {
            n += this.getRowVector(i).hashCode();
        }
        return n;
    }

    @Override
    public abstract int rows();

    @Override
    public abstract void set(int var1, int var2, double var3);

    @Override
    public void setColumn(int n, double[] dArray) {
        this.setColumn(n, Vectors.asVector(dArray));
    }

    @Override
    public void setColumn(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.rows()) {
            throw new IllegalArgumentException("Number of values is not equal the number of rows");
        }
        for (int i = 0; i < doubleVector.length(); ++i) {
            this.set(i, n, doubleVector.get(i));
        }
    }

    @Override
    public void setRow(int n, double[] dArray) {
        this.setRow(n, Vectors.asVector(dArray));
    }

    @Override
    public void setRow(int n, DoubleVector doubleVector) {
        if (doubleVector.length() != this.columns()) {
            throw new IllegalArgumentException("Number of values is not equal the number of rows");
        }
        for (int i = 0; i < doubleVector.length(); ++i) {
            this.set(n, i, doubleVector.get(i));
        }
    }

    @Override
    public double[][] toDenseArray() {
        double[][] dArray = new double[this.rows()][this.columns()];
        for (int i = 0; i < this.rows(); ++i) {
            dArray[i] = this.getRowVector(i).toArray();
        }
        return dArray;
    }
}

