/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.ri.IndexVectorUtil;
import edu.ucla.sspace.ri.RandomIndexing;
import edu.ucla.sspace.vector.TernaryVector;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class RandomIndexingMain
extends GenericMain {
    private static final Logger LOGGER = Logger.getLogger(RandomIndexingMain.class.getName());
    private Properties props;
    private RandomIndexing ri = null;

    private RandomIndexingMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('l', "vectorLength", "length of semantic vectors", true, "INT", "Algorithm Options");
        argOptions.addOption('n', "permutationFunction", "permutation function to use.  This should be genric for TernaryVectors", true, "CLASSNAME", "Advanced Algorithm Options");
        argOptions.addOption('p', "usePermutations", "whether to permute index vectors based on word order", true, "BOOL", "Algorithm Options");
        argOptions.addOption('r', "useSparseSemantics", "use a sparse encoding of semantics to save memory", true, "BOOL", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "how many words to consider in each direction", true, "INT", "Algorithm Options");
        argOptions.addOption('S', "saveVectors", "save word-to-IndexVector mapping after processing", true, "FILE", "Algorithm Options");
        argOptions.addOption('L', "loadVectors", "load word-to-IndexVector mapping before processing", true, "FILE", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        try {
            RandomIndexingMain randomIndexingMain = new RandomIndexingMain();
            randomIndexingMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected Properties setupProperties() {
        this.props = System.getProperties();
        if (this.argOptions.hasOption("usePermutations")) {
            this.props.setProperty("edu.ucla.sspace.ri.RandomIndexing.usePermutations", this.argOptions.getStringOption("usePermutations"));
        }
        if (this.argOptions.hasOption("permutationFunction")) {
            this.props.setProperty("edu.ucla.sspace.ri.RandomIndexing.permutationFunction", this.argOptions.getStringOption("permutationFunction"));
        }
        if (this.argOptions.hasOption("windowSize")) {
            this.props.setProperty("edu.ucla.sspace.ri.RandomIndexing.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("vectorLength")) {
            this.props.setProperty("edu.ucla.sspace.ri.RandomIndexing.vectorLength", this.argOptions.getStringOption("vectorLength"));
        }
        if (this.argOptions.hasOption("useSparseSemantics")) {
            this.props.setProperty("edu.ucla.sspace.ri.RandomIndexing.sparseSemantics", this.argOptions.getStringOption("useSparseSemantics"));
        }
        return this.props;
    }

    @Override
    protected SemanticSpace getSpace() {
        this.ri = new RandomIndexing(this.props);
        if (this.argOptions.hasOption("loadVectors")) {
            String string = this.argOptions.getStringOption("loadVectors");
            LOGGER.info("loading index vectors from " + string);
            Map<String, TernaryVector> map = IndexVectorUtil.load(new File(string));
            this.ri.setWordToIndexVector(map);
        }
        return this.ri;
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption("saveVectors")) {
            String string = this.argOptions.getStringOption("saveVectors");
            LOGGER.info("saving index vectors to " + string);
            IndexVectorUtil.save(this.ri.getWordToIndexVector(), new File(string));
        }
    }
}

