/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.RandomIndexVectorGenerator;
import edu.ucla.sspace.mains.GenericWordsiMain;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.RandomIndexingContextGenerator;
import java.util.Map;

public class RIWordsiMain
extends GenericWordsiMain {
    private PermutationFunction<TernaryVector> permFunction;
    private Map<String, TernaryVector> indexMap;
    private int indexVectorLength;

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('p', "permutationFunction", "Specifies the permutation function to apply on index vectors. (Default: none)", true, "CLASSNAME", "Optional");
        argOptions.addOption('l', "indexVectorLength", "Specifies the length of index vectors.", true, "CLASSNAME", "Required");
    }

    @Override
    protected void handleExtraOptions() {
        this.indexVectorLength = this.argOptions.getIntOption('l');
        if (this.argOptions.hasOption('p')) {
            this.permFunction = (PermutationFunction)ReflectionUtil.getObjectInstance(this.argOptions.getStringOption('p'));
        }
        this.indexMap = this.argOptions.hasOption('L') ? (Map)this.loadObject(this.openLoadFile()) : new GeneratorMap<TernaryVector>(new RandomIndexVectorGenerator(this.indexVectorLength));
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption('S')) {
            this.saveObject(this.openSaveFile(), this.indexMap);
        }
    }

    @Override
    protected ContextExtractor getExtractor() {
        RandomIndexingContextGenerator randomIndexingContextGenerator = new RandomIndexingContextGenerator(this.indexMap, this.permFunction, this.indexVectorLength);
        return this.contextExtractorFromGenerator(randomIndexingContextGenerator);
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_TEXT;
    }

    public static void main(String[] stringArray) throws Exception {
        RIWordsiMain rIWordsiMain = new RIWordsiMain();
        rIWordsiMain.run(stringArray);
    }
}

