/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.isa.IncrementalSemanticAnalysis;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.ri.IndexVectorUtil;
import edu.ucla.sspace.vector.TernaryVector;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class IsaMain
extends GenericMain {
    private static final Logger LOGGER = Logger.getLogger(IsaMain.class.getName());
    private Properties props = null;
    private IncrementalSemanticAnalysis isa = null;

    private IsaMain() {
        super(false);
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('h', "historyDecayRate", "the decay rate for history effects of co-occurring words", true, "DOUBLE", "Algorithm Options");
        argOptions.addOption('i', "impactRate", "the rate at which co-occurrence affects semantics", true, "DOUBLE", "Algorithm Options");
        argOptions.addOption('l', "vectorLength", "length of semantic vectors", true, "INT", "Algorithm Options");
        argOptions.addOption('L', "loadVectors", "load word-to-TernaryVector mapping before processing", true, "FILE", "Algorithm Options");
        argOptions.addOption('n', "permutationFunction", "permutation function to use.  This should be generic for TernaryVectors", true, "CLASSNAME", "Advanced Algorithm Options");
        argOptions.addOption('p', "usePermutations", "whether to permute index vectors based on word order", true, "BOOL", "Algorithm Options");
        argOptions.addOption('r', "useSparseSemantics", "use a sparse encoding of semantics to save memory", true, "BOOL", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "how many words to consider in each direction", true, "INT", "Algorithm Options");
        argOptions.addOption('S', "saveVectors", "save word-to-IndexVector mapping after processing", true, "FILE", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        IsaMain isaMain = new IsaMain();
        try {
            isaMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpace getSpace() {
        this.isa = new IncrementalSemanticAnalysis();
        if (this.argOptions.hasOption("loadVectors")) {
            String string = this.argOptions.getStringOption("loadVectors");
            LOGGER.info("loading index vectors from " + string);
            Map<String, TernaryVector> map = IndexVectorUtil.load(new File(string));
            this.isa.setWordToIndexVector(map);
        }
        return this.isa;
    }

    @Override
    protected Properties setupProperties() {
        this.props = System.getProperties();
        if (this.argOptions.hasOption("usePermutations")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.usePermutations", this.argOptions.getStringOption("usePermutations"));
        }
        if (this.argOptions.hasOption("permutationFunction")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.permutationFunction", this.argOptions.getStringOption("permutationFunction"));
        }
        if (this.argOptions.hasOption("windowSize")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("vectorLength")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.vectorLength", this.argOptions.getStringOption("vectorLength"));
        }
        if (this.argOptions.hasOption("useSparseSemantics")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.sparseSemantics", this.argOptions.getStringOption("useSparseSemantics"));
        }
        if (this.argOptions.hasOption("impactRate")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.impactRate", this.argOptions.getStringOption("impactRate"));
        }
        if (this.argOptions.hasOption("historyDecayRate")) {
            this.props.setProperty("edu.ucla.sspace.isa.IncrementalSemanticAnalysis.historyDecayRate", this.argOptions.getStringOption("historyDecayRate"));
        }
        return this.props;
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption("saveVectors")) {
            String string = this.argOptions.getStringOption("saveVectors");
            LOGGER.info("saving index vectors to " + string);
            IndexVectorUtil.save(this.isa.getWordToIndexVector(), new File(string));
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected String getAlgorithmSpecifics() {
        return "ISA is an incremental algorithm where the semantics is based on co-occurrence\nof words.  Semantics accumulate as a function both the index vectors and\nthe semantics of the co-occurring words.  Documents are processed in the\norder they are specified,with documents in --fileList processed before\ndocuments specified by the --docFile option.\n\nThe impact rate specifies the degree to which the co-occurrence of a word\nimpacts the semantics of another word.  This value affects both of the\nimpact of index vectors and semantics.  Thedefault rate is 0.003.\n\nThe history decay rate specifies how quickly to reduce the impact of the\nsemantics of a co-occurring word as the total number of occurrences for that\nword increases.  High decay rates cause the semantics to be discounted more\nquickly.  The default rate is 100.";
    }
}

