/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage;
import edu.ucla.sspace.mains.GenericMain;
import java.util.Properties;

public class HALMain
extends GenericMain {
    private HALMain() {
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.addOption('h', "threshold", "minimum entropy for semantic dimensions (default: disabled)", true, "DOUBLE", "Algorithm Options");
        argOptions.addOption('r', "retain", "maximum number of dimensions to retain(default: disabled)", true, "INT", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "The number of words to inspect to the left and right of a focus word (default: 5)", true, "INT", "Algorithm Options");
        argOptions.addOption('W', "weighting", "WeightingFunction class name(default: LinearWeighting)", true, "CLASSNAME", "Algorithm Options");
    }

    public static void main(String[] stringArray) {
        HALMain hALMain = new HALMain();
        try {
            hALMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }

    @Override
    protected SemanticSpace getSpace() {
        return new HyperspaceAnalogueToLanguage();
    }

    @Override
    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("windowSize")) {
            properties.setProperty("edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("threshold")) {
            properties.setProperty("edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.threshold", this.argOptions.getStringOption("threshold"));
        }
        if (this.argOptions.hasOption("retain")) {
            properties.setProperty("edu.ucla.sspace.hal.retainColumns", this.argOptions.getStringOption("retain"));
        }
        if (this.argOptions.hasOption("weighting")) {
            properties.setProperty("edu.ucla.sspace.hal.weighting", this.argOptions.getStringOption("weighting"));
        }
        return properties;
    }

    @Override
    protected String getAlgorithmSpecifics() {
        return "Note that the --retain and --threshold properties are mutually exclusive;\nusing both will cause an exception";
    }
}

