/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.clustering.Clustering;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.mains.GenericMain;
import edu.ucla.sspace.text.Document;
import edu.ucla.sspace.util.Generator;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.wordsi.AssignmentReporter;
import edu.ucla.sspace.wordsi.ContextExtractor;
import edu.ucla.sspace.wordsi.ContextGenerator;
import edu.ucla.sspace.wordsi.EvaluationWordsi;
import edu.ucla.sspace.wordsi.GeneralContextExtractor;
import edu.ucla.sspace.wordsi.StreamingWordsi;
import edu.ucla.sspace.wordsi.WaitingWordsi;
import edu.ucla.sspace.wordsi.psd.PseudoWordContextExtractor;
import edu.ucla.sspace.wordsi.psd.PseudoWordReporter;
import edu.ucla.sspace.wordsi.semeval.SemEvalContextExtractor;
import edu.ucla.sspace.wordsi.semeval.SemEvalReporter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class GenericWordsiMain
extends GenericMain {
    private ObjectOutputStream saveStream = null;
    private ObjectInputStream loadStream = null;

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        argOptions.removeOption('Z');
        argOptions.removeOption('X');
        argOptions.removeOption('o');
        argOptions.removeOption('w');
        argOptions.addOption('s', "streamingClustering", "Specifies the streaming clustering algorithm to use for forming word senses", true, "CLASSNAME", "Required (one of)");
        argOptions.addOption('b', "batchClustering", "Specifies the batch clustering algorithm to use for forming word senses", true, "CLASSNAME", "Required (one of)");
        argOptions.addOption('e', "evaluationClustering", "Specifies a trained Wordsi semantic space to be used for evaluation.  When set, one of the Evaluation Type arguments must be set", true, "<sspace>", "Required (one of)");
        argOptions.addOption('P', "pseudoWordEvaluation", "Specifies a mapping from raw tokens to their pseudo word token.  Only the raw tokens in this mapping will be represented in the Wordsi space.  A PseudoWordReport will be generated for these pseudo words.  This overrides the -a option", true, "FILENAME", "Evaluation Type");
        argOptions.addOption('E', "semEvalEvaluation", "Signifies that the data files are in the SemEval format and that only test instance words should be represented in the Wordsi space.  Each line must correspond to an instance context and the focus word must be precceded by the token given as the argument to this option.", true, "STRING", "Evaluation Type");
        argOptions.addOption('N', "wordlistEvaluation", "Learned word senses are assumed to be related to the senses in for other words in the acceptedWords list.  This evaluation will track the headers for documents which should mark whether or not the focus words are being used with their common sense.", false, null, "Evaluation Type");
        argOptions.addOption('a', "acceptedWords", "Specifies the set of words which should be represented by Wordsi. (Default: all words)", true, "FILENAME", "Optional");
        argOptions.addOption('c', "clusters", "Specifies the desired number of clusters, or word senses.  (Default: 0)", true, "INT", "Optional");
        argOptions.addOption('W', "windowSize", "Specifies the number of words, in one direction, that form a valid context.  For example, a window size of 5 means that up to 5 words before and after a focus word are used to form the context. (Default: 5)", true, "INT", "Optional");
        argOptions.addOption('h', "useHeaderToken", "Set to true if the first token in a context should be treated as a document header. Note that this is only used when -E and -P are not used.", false, null, "Optional");
        argOptions.addOption('S', "save", "Specfies a file to which all files needed to generate context vectors will be serialized", true, "FILENAME", "Serialization");
        argOptions.addOption('L', "load", "Specfies a file from which all files needed to generate context vectors will be deserialized", true, "FILENAME", "Serialization");
    }

    protected abstract ContextExtractor getExtractor();

    protected Set<String> getAcceptedWords() {
        if (!this.argOptions.hasOption('a')) {
            return null;
        }
        try {
            HashSet<String> hashSet = new HashSet<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.argOptions.getStringOption('a')));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                hashSet.add(string.trim().toLowerCase());
            }
            return hashSet;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected Map<String, String> getPseudoWordMap() {
        if (!this.argOptions.hasOption('P')) {
            return null;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.argOptions.getStringOption('P')));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split("\\s+");
                hashMap.put(stringArray[0].trim(), stringArray[1].trim());
            }
            return hashMap;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected ContextExtractor contextExtractorFromGenerator(ContextGenerator contextGenerator) {
        if (this.argOptions.hasOption('e')) {
            contextGenerator.setReadOnly(true);
        }
        if (this.argOptions.hasOption('E')) {
            return new SemEvalContextExtractor(contextGenerator, this.windowSize(), this.argOptions.getStringOption('E'));
        }
        if (this.argOptions.hasOption('P')) {
            return new PseudoWordContextExtractor(contextGenerator, this.windowSize(), this.getPseudoWordMap());
        }
        return new GeneralContextExtractor(contextGenerator, this.windowSize(), this.argOptions.hasOption('h'));
    }

    protected int windowSize() {
        return this.argOptions.getIntOption('W', 5);
    }

    @Override
    protected Iterator<Document> getDocumentIterator() throws IOException {
        Iterator<Document> iterator = super.getDocumentIterator();
        if (!this.argOptions.hasOption('P')) {
            return iterator;
        }
        LinkedList<Document> linkedList = new LinkedList<Document>();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        Collections.shuffle(linkedList);
        return linkedList.iterator();
    }

    @Override
    protected SemanticSpace getSpace() {
        ArgOptions argOptions = this.argOptions;
        AssignmentReporter assignmentReporter = null;
        if (argOptions.hasOption('P')) {
            assignmentReporter = new PseudoWordReporter(System.out);
        }
        int n = argOptions.getIntOption('c', 0);
        if (argOptions.hasOption('e')) {
            if (!argOptions.hasOption('E') && !argOptions.hasOption('P')) {
                this.usage();
                System.out.println("An Evaluation Type must be set when evaluating  a trained Wordsi model.");
                System.exit(1);
            }
            try {
                SemanticSpace semanticSpace = SemanticSpaceIO.load(argOptions.getStringOption('e'));
                if (argOptions.hasOption('E')) {
                    assignmentReporter = new SemEvalReporter(System.out);
                }
                return new EvaluationWordsi(this.getAcceptedWords(), this.getExtractor(), semanticSpace, assignmentReporter);
            }
            catch (IOException iOException) {
                throw new IOError(iOException);
            }
        }
        if (argOptions.hasOption('s')) {
            System.getProperties().setProperty("edu.ucla.sspace.clustering.OnlineClustering.numClusters", argOptions.getStringOption('c'));
            Generator generator = (Generator)ReflectionUtil.getObjectInstance(argOptions.getStringOption('s'));
            return new StreamingWordsi(this.getAcceptedWords(), this.getExtractor(), generator, assignmentReporter, n);
        }
        if (argOptions.hasOption('b')) {
            Clustering clustering = (Clustering)ReflectionUtil.getObjectInstance(argOptions.getStringOption('b'));
            return new WaitingWordsi(this.getAcceptedWords(), this.getExtractor(), clustering, assignmentReporter, n);
        }
        this.usage();
        System.out.println("No clustering method was specified.");
        System.exit(1);
        return null;
    }

    protected ObjectOutputStream openSaveFile() {
        try {
            if (this.saveStream == null && this.argOptions.hasOption('S')) {
                this.saveStream = new ObjectOutputStream(new FileOutputStream(this.argOptions.getStringOption('S')));
            }
            return this.saveStream;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected ObjectInputStream openLoadFile() {
        try {
            if (this.loadStream == null && this.argOptions.hasOption('L')) {
                this.loadStream = new ObjectInputStream(new FileInputStream(this.argOptions.getStringOption('L')));
            }
            return this.loadStream;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected void saveObject(ObjectOutputStream objectOutputStream, Object object) {
        try {
            objectOutputStream.writeObject(object);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    protected <T> T loadObject(ObjectInputStream objectInputStream) {
        try {
            return (T)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOError(classNotFoundException);
        }
    }
}

