/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.common.WordComparator;
import edu.ucla.sspace.ri.IndexVectorUtil;
import edu.ucla.sspace.text.FileListTemporalDocumentIterator;
import edu.ucla.sspace.text.OneLinePerTemporalDocumentIterator;
import edu.ucla.sspace.text.TemporalDocument;
import edu.ucla.sspace.tri.FixedDurationTemporalRandomIndexing;
import edu.ucla.sspace.util.CombinedIterator;
import edu.ucla.sspace.util.MultiMap;
import edu.ucla.sspace.util.SortedMultiMap;
import edu.ucla.sspace.util.TimeSpan;
import edu.ucla.sspace.util.TreeMultiMap;
import edu.ucla.sspace.vector.TernaryVector;
import edu.ucla.sspace.vector.Vector;
import edu.ucla.sspace.vector.Vectors;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedDurationTemporalRandomIndexingMain {
    private static final String EXT = ".sspace";
    private static final Logger LOGGER = Logger.getLogger(FixedDurationTemporalRandomIndexingMain.class.getName());
    private final ArgOptions argOptions = this.createOptions();
    private final Set<String> interestingWords = new HashSet<String>();
    private boolean compareNeighbors = false;
    private SemanticSpaceIO.SSpaceFormat format;
    private int interestingWordNeighbors = 0;
    private File outputDir;
    private boolean overwrite;
    private boolean printInterestingTokenShifts;
    private boolean savePartitions = false;
    private boolean printShiftRankings = false;
    private WordComparator wordComparator;
    private final Map<String, SortedMap<Long, double[]>> wordToTemporalSemantics = new HashMap<String, SortedMap<Long, double[]>>();

    private FixedDurationTemporalRandomIndexingMain() {
    }

    protected ArgOptions createOptions() {
        ArgOptions argOptions = new ArgOptions();
        argOptions.addOption('f', "fileList", "a list of document files", true, "FILE[,FILE...]", "Required (at least one of)");
        argOptions.addOption('d', "docFile", "a file where each line is a document", true, "FILE[,FILE...]", "Required (at least one of)");
        argOptions.addOption('T', "timespan", "the timespan for each semantic partition", true, "Date String", "Required");
        argOptions.addOption('o', "outputFormat", "the .sspace format to use", true, "{text|binary}", "Program Options");
        argOptions.addOption('t', "threads", "the number of threads to use", true, "INT", "Program Options");
        argOptions.addOption('w', "overwrite", "specifies whether to overwrite the existing output", true, "BOOL", "Program Options");
        argOptions.addOption('v', "verbose", "prints verbose output", false, null, "Program Options");
        argOptions.addOption('i', "vectorGenerator", "IndexVectorGenerator class to use", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('l', "vectorLength", "length of semantic vectors", true, "INT", "Algorithm Options");
        argOptions.addOption('n', "permutationFunction", "permutation function to use", true, "CLASSNAME", "Algorithm Options");
        argOptions.addOption('p', "usePermutations", "whether to permute index vectors based on word order", true, "BOOL", "Algorithm Options");
        argOptions.addOption('r', "useSparseSemantics", "use a sparse encoding of semantics to save memory", true, "BOOL", "Algorithm Options");
        argOptions.addOption('s', "windowSize", "how many words to consider in each direction", true, "INT", "Algorithm Options");
        argOptions.addOption('S', "saveVectors", "save word-to-IndexVector mapping after processing", true, "FILE", "Algorithm Options");
        argOptions.addOption('L', "loadVectors", "load word-to-IndexVector mapping before processing", true, "FILE", "Algorithm Options");
        argOptions.addOption('F', "tokenFilter", "filters to apply to the input token stream", true, "FILTER_SPEC", "Tokenizing Options");
        argOptions.addOption('C', "compoundWords", "a file where each line is a recognized compound word", true, "FILE", "Tokenizing Options");
        argOptions.addOption('W', "semanticFilter", "exclusive list of word", true, "FILE", "Input Options");
        argOptions.addOption('I', "interestingTokenList", "list of interesting words", true, "FILE", "Output Options");
        argOptions.addOption('K', "printShiftRankings", "print ranked list of semantic shifts for each interesting word", false, null, "Output Options");
        argOptions.addOption('R', "savePartitions", "write semantic partitions as .sspace files to disk", false, null, "Output Options");
        argOptions.addOption('P', "printInterestingTokenShifts", "prints the vectors for each interesting word", false, null, "Output Options");
        argOptions.addOption('N', "printInterestingTokenNeighbors", "prints the nearest neighbors for each interesting word", true, "INT", "Output Options");
        argOptions.addOption('Z', "printInterestingTokenNeighborComparison", "prints the distances between each of thenearest neighbors for each interesting word", false, null, "Output Options");
        return argOptions;
    }

    public static void main(String[] stringArray) {
        try {
            FixedDurationTemporalRandomIndexingMain fixedDurationTemporalRandomIndexingMain = new FixedDurationTemporalRandomIndexingMain();
            fixedDurationTemporalRandomIndexingMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        String[] stringArray2;
        String string;
        ConsoleHandler consoleHandler;
        Object object3;
        if (stringArray.length == 0) {
            this.usage();
            System.exit(1);
        }
        this.argOptions.parseOptions(stringArray);
        if (this.argOptions.numPositionalArgs() == 0) {
            throw new IllegalArgumentException("must specify output directory");
        }
        this.outputDir = new File(this.argOptions.getPositionalArg(0));
        if (!this.outputDir.isDirectory()) {
            throw new IllegalArgumentException("output directory is not a directory: " + this.outputDir);
        }
        if (!this.argOptions.hasOption("timespan")) {
            throw new IllegalArgumentException("must specify a timespan duration for the semantic partition");
        }
        String string2 = this.argOptions.getStringOption("timespan");
        TimeSpan timeSpan = new TimeSpan(string2);
        if (this.argOptions.hasOption('v') || this.argOptions.hasOption("verbose")) {
            object3 = Logger.getLogger("edu.ucla.sspace");
            consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.FINE);
            ((Logger)object3).addHandler(consoleHandler);
            ((Logger)object3).setLevel(Level.FINE);
            ((Logger)object3).setUseParentHandlers(false);
        }
        object3 = null;
        consoleHandler = this.argOptions.hasOption("fileList") ? this.argOptions.getStringOption("fileList") : null;
        String string3 = string = this.argOptions.hasOption("docFile") ? this.argOptions.getStringOption("docFile") : null;
        if (consoleHandler == null && string == null) {
            throw new Error("must specify document sources");
        }
        LinkedList linkedList = new LinkedList();
        if (consoleHandler != null) {
            for (String string4 : stringArray2 = ((String)((Object)consoleHandler)).split(",")) {
                linkedList.add(new FileListTemporalDocumentIterator(string4));
            }
        }
        if (string != null) {
            for (String string5 : stringArray2 = string.split(",")) {
                linkedList.add(new OneLinePerTemporalDocumentIterator(string5));
            }
        }
        object3 = new CombinedIterator(linkedList);
        int n = Runtime.getRuntime().availableProcessors();
        if (this.argOptions.hasOption("threads")) {
            n = this.argOptions.getIntOption("threads");
        }
        this.wordComparator = new WordComparator(n);
        this.overwrite = true;
        if (this.argOptions.hasOption("overwrite")) {
            this.overwrite = this.argOptions.getBooleanOption("overwrite");
        }
        if (this.argOptions.hasOption("interestingTokenList")) {
            String string6 = this.argOptions.getStringOption("interestingTokenList");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string6));
            String string7 = null;
            while ((string7 = bufferedReader.readLine()) != null) {
                for (String string8 : string7.split("\\s+")) {
                    this.interestingWords.add(string8);
                    this.wordToTemporalSemantics.put(string8, new TreeMap());
                }
            }
            LOGGER.info("loaded " + this.interestingWords.size() + " interesting words");
        }
        if (this.argOptions.hasOption("savePartitions")) {
            this.savePartitions = true;
        }
        if (this.argOptions.hasOption("printShiftRankings")) {
            this.printShiftRankings = true;
        } else if (this.interestingWords.isEmpty()) {
            throw new IllegalArgumentException("Must specify some form of output as either a non-empty setof interesting words and/or writing the semantic partition .sspacefiles to disk");
        }
        if (this.argOptions.hasOption("printInterestingTokenNeighbors")) {
            this.interestingWordNeighbors = this.argOptions.getIntOption("printInterestingTokenNeighbors");
        }
        if (this.argOptions.hasOption("printInterestingTokenShifts")) {
            this.printInterestingTokenShifts = true;
            LOGGER.info("Recording interesting token shifts");
        }
        if (this.argOptions.hasOption("printInterestingTokenNeighborComparison")) {
            this.compareNeighbors = true;
        }
        Properties properties = this.setupProperties();
        FixedDurationTemporalRandomIndexing fixedDurationTemporalRandomIndexing = new FixedDurationTemporalRandomIndexing(properties);
        if (this.argOptions.hasOption("semanticFilter")) {
            String string9 = this.argOptions.getStringOption("semanticFilter");
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string9));
            HashSet<String> hashSet = new HashSet<String>();
            String string10 = null;
            while ((string10 = bufferedReader.readLine()) != null) {
                for (String string11 : string10.split("\\s+")) {
                    hashSet.add(string11);
                }
            }
            LOGGER.info("computing semantics for only " + hashSet.size() + " words");
            fixedDurationTemporalRandomIndexing.setSemanticFilter(hashSet);
        }
        if (this.argOptions.hasOption("loadVectors")) {
            String string12 = this.argOptions.getStringOption("loadVectors");
            LOGGER.info("loading index vectors from " + string12);
            Map<String, TernaryVector> map = IndexVectorUtil.load(new File(string12));
            fixedDurationTemporalRandomIndexing.setWordToIndexVector(map);
        }
        String string13 = this.argOptions.hasOption("outputFormat") ? this.argOptions.getStringOption("outputFormat").toUpperCase() : "TEXT";
        this.format = SemanticSpaceIO.SSpaceFormat.valueOf(string13.toUpperCase());
        this.parseDocumentsMultiThreaded(fixedDurationTemporalRandomIndexing, (Iterator<TemporalDocument>)object3, timeSpan, n);
        long l = System.currentTimeMillis();
        fixedDurationTemporalRandomIndexing.processSpace(properties);
        long l2 = System.currentTimeMillis();
        LOGGER.info(String.format("processed space in %.3f seconds%n", (double)(l2 - l) / 1000.0));
        if (this.argOptions.hasOption("saveVectors")) {
            String string14 = this.argOptions.getStringOption("saveVectors");
            LOGGER.info("saving index vectors to " + string14);
            IndexVectorUtil.save(fixedDurationTemporalRandomIndexing.getWordToIndexVector(), new File(string14));
        }
    }

    private void printSpace(SemanticSpace semanticSpace, String string) {
        try {
            String string2 = EXT;
            File file = this.overwrite ? new File(this.outputDir, semanticSpace.getSpaceName() + string + string2) : File.createTempFile(semanticSpace.getSpaceName() + string, string2, this.outputDir);
            long l = System.currentTimeMillis();
            SemanticSpaceIO.save(semanticSpace, file, this.format);
            long l2 = System.currentTimeMillis();
            this.verbose("printed space in %.3f seconds%n", (double)(l2 - l) / 1000.0);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    private void updateTemporalSemantics(long l, SemanticSpace semanticSpace) {
        double[] dArray = new double[semanticSpace.getVectorLength()];
        for (String string : this.interestingWords) {
            SortedMap<Long, double[]> sortedMap = this.wordToTemporalSemantics.get(string);
            Vector vector = semanticSpace.getVector(string);
            double[] dArray2 = vector == null ? dArray : Vectors.asDouble(vector).toArray();
            sortedMap.put(l, dArray2);
        }
    }

    private void printSemanticShifts(String string) throws IOException {
        LOGGER.fine("Writing semantic shifts for " + string);
        for (Map.Entry<String, SortedMap<Long, double[]>> entry : this.wordToTemporalSemantics.entrySet()) {
            String string2 = entry.getKey();
            SortedMap<Long, double[]> sortedMap = entry.getValue();
            Iterator<Map.Entry<Long, double[]>> iterator = sortedMap.entrySet().iterator();
            PrintWriter printWriter = new PrintWriter(new File(this.outputDir, string2 + "." + string + ".temporal-changes.txt"));
            printWriter.println("#time\ttime-delay\tcosineSim\tcosineAngle\tEuclidean\tchange-in-magnitde\tmagnitde\tprev-magnitude");
            Map.Entry<Long, double[]> entry2 = null;
            while (iterator.hasNext()) {
                Map.Entry<Long, double[]> entry3 = iterator.next();
                if (entry2 != null) {
                    long l = entry3.getKey() - entry2.getKey();
                    double d = Similarity.euclideanDistance(entry3.getValue(), entry2.getValue());
                    double d2 = Similarity.cosineSimilarity(entry3.getValue(), entry2.getValue());
                    double d3 = Math.acos(d2);
                    double d4 = FixedDurationTemporalRandomIndexingMain.getMagnitude(entry2.getValue());
                    double d5 = FixedDurationTemporalRandomIndexingMain.getMagnitude(entry3.getValue());
                    printWriter.println(entry3.getKey() + "\t" + l + "\t" + d2 + "\t" + d3 + "\t" + d + "\t" + (d5 - d4) + "\t" + d5 + "\t" + d4);
                }
                entry2 = entry3;
            }
            printWriter.close();
        }
    }

    private void printShiftRankings(String string, long l, TimeSpan timeSpan) throws IOException {
        TreeMultiMap<Double, String> treeMultiMap = new TreeMultiMap<Double, String>();
        TimeSpan timeSpan2 = new TimeSpan(timeSpan.getYears() * 2, timeSpan.getMonths() * 2, timeSpan.getWeeks() * 2, timeSpan.getDays() * 2, timeSpan.getHours() * 2);
        for (Map.Entry<String, SortedMap<Long, double[]>> object : this.wordToTemporalSemantics.entrySet()) {
            Map.Entry entry;
            NavigableMap<Object, Object> navigableMap;
            Map.Entry entry2;
            String string2 = object.getKey();
            SortedMap<Long, double[]> sortedMap = object.getValue();
            if (sortedMap.size() < 2 || !((Long)(entry2 = (navigableMap = object instanceof NavigableMap ? (NavigableMap<Object, Object>)sortedMap : new TreeMap<Long, double[]>(sortedMap)).lastEntry()).getKey()).equals(l) || !timeSpan2.insideRange((Long)(entry = navigableMap.lowerEntry(entry2.getKey())).getKey(), (Long)entry2.getKey())) continue;
            treeMultiMap.put(Similarity.cosineSimilarity((double[])entry.getValue(), (double[])entry2.getValue()), string2);
        }
        PrintWriter printWriter = new PrintWriter(new File(this.outputDir, "shift-ranks-for." + string + ".txt"));
        for (Map.Entry entry : treeMultiMap.entrySet()) {
            printWriter.println(entry.getKey() + "\t" + (String)entry.getValue());
        }
        printWriter.close();
    }

    private void printWordNeighbors(String string, SemanticSpace semanticSpace) throws IOException {
        LOGGER.info("printing the most similar words for the semantic partition starting at: " + string);
        for (String string2 : this.interestingWords) {
            SortedMultiMap<Double, String> sortedMultiMap = this.wordComparator.getMostSimilar(string2, semanticSpace, this.interestingWordNeighbors, Similarity.SimType.COSINE);
            if (sortedMultiMap == null) continue;
            File file = new File(this.outputDir, string2 + "-" + string + ".txt");
            file.createNewFile();
            File file2 = new File(this.outputDir, string2 + "_neighbor-comparisons_" + string + ".txt");
            file2.createNewFile();
            PrintWriter printWriter = new PrintWriter(file);
            for (String string3 : sortedMultiMap.values()) {
                printWriter.println(string3);
            }
            printWriter.close();
            if (!this.compareNeighbors) continue;
            FixedDurationTemporalRandomIndexingMain.writeNeighborComparison(file2, sortedMultiMap, semanticSpace);
        }
    }

    private static void writeNeighborComparison(File file, MultiMap<Double, String> multiMap, SemanticSpace semanticSpace) throws IOException {
        PrintWriter printWriter = new PrintWriter(file);
        StringBuffer stringBuffer = new StringBuffer(multiMap.size() * 10);
        Iterator<String> iterator = multiMap.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(" ");
        }
        printWriter.println(stringBuffer.toString());
        for (String string : multiMap.values()) {
            stringBuffer = new StringBuffer(multiMap.size() * 10);
            stringBuffer.append(string).append(" ");
            for (String string2 : multiMap.values()) {
                double d = Similarity.cosineSimilarity(semanticSpace.getVector(string), semanticSpace.getVector(string2));
                stringBuffer.append(d).append(" ");
            }
            printWriter.println(stringBuffer.toString());
        }
        printWriter.close();
    }

    protected Properties setupProperties() {
        Properties properties = System.getProperties();
        if (this.argOptions.hasOption("usePermutations")) {
            properties.setProperty("edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.usePermutations", this.argOptions.getStringOption("usePermutations"));
        }
        if (this.argOptions.hasOption("permutationFunction")) {
            properties.setProperty("edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.permutationFunction", this.argOptions.getStringOption("permutationFunction"));
        }
        if (this.argOptions.hasOption("windowSize")) {
            properties.setProperty("edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.windowSize", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("vectorLength")) {
            properties.setProperty("edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.vectorLength", this.argOptions.getStringOption("vectorLength"));
        }
        if (this.argOptions.hasOption("useSparseSemantics")) {
            properties.setProperty("edu.ucla.sspace.tri.OrderedTemporalRandomIndexing.sparseSemantics", this.argOptions.getStringOption("useSparseSemantics"));
        }
        if (this.argOptions.hasOption("partitionDuration")) {
            properties.setProperty("edu.ucla.sspace.tri.FixedDurationTemporalRandomIndexing.partitionDuration", this.argOptions.getStringOption("partitionDuration"));
        }
        if (this.argOptions.hasOption("tokenFilter")) {
            properties.setProperty("edu.ucla.sspace.text.TokenizerFactory.tokenFilter", this.argOptions.getStringOption("tokenFilter"));
        }
        if (this.argOptions.hasOption("compoundTokens")) {
            properties.setProperty("edu.ucla.sspace.text.TokenizerFactory.compoundTokens", this.argOptions.getStringOption("compoundTokens"));
        }
        return properties;
    }

    private static double getMagnitude(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            if (d2 == 0.0) continue;
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    protected void parseDocumentsMultiThreaded(final FixedDurationTemporalRandomIndexing fixedDurationTemporalRandomIndexing, final Iterator<TemporalDocument> iterator, final TimeSpan timeSpan, int n) throws IOException, InterruptedException {
        LinkedList<2> linkedList = new LinkedList<2>();
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        final AtomicLong atomicLong = new AtomicLong();
        Object object = new Object();
        final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_ww_dd_hh");
        AtomicLong atomicLong2 = new AtomicLong();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final ConcurrentLinkedQueue concurrentLinkedQueue = new ConcurrentLinkedQueue();
        final boolean bl = this.savePartitions;
        final boolean bl2 = this.printInterestingTokenShifts;
        boolean bl3 = this.interestingWordNeighbors > 0;
        final boolean bl4 = this.printShiftRankings;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(atomicLong.get());
                String string = simpleDateFormat.format(calendar.getTime());
                try {
                    if (bl) {
                        LOGGER.info("writing semantic partition starting at: " + string);
                        FixedDurationTemporalRandomIndexingMain.this.printSpace(fixedDurationTemporalRandomIndexing, "-" + string);
                    }
                    FixedDurationTemporalRandomIndexingMain.this.updateTemporalSemantics(atomicLong.get(), fixedDurationTemporalRandomIndexing);
                    if (bl2) {
                        FixedDurationTemporalRandomIndexingMain.this.printSemanticShifts(string);
                    }
                    if (bl4) {
                        FixedDurationTemporalRandomIndexingMain.this.printShiftRankings(string, atomicLong.get(), timeSpan);
                    }
                    if (FixedDurationTemporalRandomIndexingMain.this.interestingWordNeighbors > 0) {
                        FixedDurationTemporalRandomIndexingMain.this.printWordNeighbors(string, fixedDurationTemporalRandomIndexing);
                    }
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
                assert (concurrentLinkedQueue.size() > 0);
                Long l = (Long)new TreeSet(concurrentLinkedQueue).first();
                concurrentLinkedQueue.clear();
                atomicLong.set(l);
            }
        };
        final CyclicBarrier cyclicBarrier = new CyclicBarrier(n, runnable);
        for (int i = 0; i < n; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    while (iterator.hasNext()) {
                        TemporalDocument temporalDocument = (TemporalDocument)iterator.next();
                        int n = atomicInteger.incrementAndGet();
                        long l = temporalDocument.timeStamp();
                        if (n == 1) {
                            atomicLong.set(l);
                            atomicBoolean.set(true);
                        }
                        while (!atomicBoolean.get()) {
                        }
                        while (!timeSpan.insideRange(atomicLong.get(), l)) {
                            try {
                                concurrentLinkedQueue.offer(l);
                                cyclicBarrier.await();
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                            catch (BrokenBarrierException brokenBarrierException) {
                                return;
                            }
                        }
                        try {
                            fixedDurationTemporalRandomIndexing.processDocument(temporalDocument.reader());
                        }
                        catch (IOException iOException) {
                            throw new IOError(iOException);
                        }
                        LOGGER.fine("parsed document #" + n);
                    }
                }
            };
            linkedList.add(thread);
        }
        long l = System.currentTimeMillis();
        for (Thread thread : linkedList) {
            thread.start();
        }
        this.verbose("Beginning processing using %d threads", n);
        for (Thread thread : linkedList) {
            thread.join();
        }
        this.verbose("parsed %d document in %.3f total seconds)%n", atomicInteger.get(), (double)(System.currentTimeMillis() - l) / 1000.0);
    }

    protected void usage() {
        System.out.println("usage: java FixedDurationTemporalRandomIndexingMain [options] <output-dir>\n\n" + this.argOptions.prettyPrint() + "\nFixed-Duration TRI provides four main output options:\n\n" + "  1) Outputting each semantic partition as a separate .sspace file.  " + "Each file\n     is named using the yyyy_MM_ww_dd_hh format to " + "indicate it start date.\n     This is the most expensive of the " + "operations due to I/O overhead.\n\n" + "  The remaining options require the use of the -I " + "--interestingTokenList option to\n  specify a set of word for use" + " in tracking temporal changes.\n\n  2) For each of the interesting" + "words, -P, --printInterestingTokenShifts will track\n" + "     the semantics" + " through time and report the semantic shift along with other\n" + "     distance statistics.\n\n" + "  3) For each of the interesting words, -N, " + "--printInterestingTokenNeighbors\n     will print the nearest " + "neighbor for each in the semantic space.  The\n     number " + "of neighbors to print should be specified.\n\n" + "  4) For each of the interesting words, generate the list of " + "similar\n     neighbors using the --printInterestingTokenNeighbors" + " and then compare\n     those neighbors with each other using " + "the\n     --printInterestingTokenNeighborComparison option.  " + "This creates a file\n     with the pair-wise cosine similarities " + "for all neighbors.  Note that this\n     option requires both " + "flags to be specified.\n\n" + "Semantic filters limit the set of tokens for which the " + "semantics are kept.\nThis limits the potential memory overhead " + "for calculating semantics for a\nlarge set of words." + "\n\n" + "The compound word option specifies a file whose contents are compount tokens,\ne.g. white house.  Each compound token should be specified on its own line.\nCompount tokenization is greedy and will select the longest compound token\npresent.  For example if \"bar exam\" and \"California bar exam\" are both\ncompound tokens, the latter will always be returned as a single token, rather\nthan returning the two tokens \"California\" and \"bar exam\"." + "\n\n" + "token configuration lists sets of files that contain tokens to be included or\nexcluded.  The behavior, \"include\" or \"exclude\" is specified\nfirst, followed by one or more file names, each separated by colons.\nMultiple behaviors may be specified one after the other using a ','\ncharacter to separate them.  For example, a typicaly configuration may\nlook like: include=top-tokens.txt:test-words.txt,exclude=stop-words.txt\nNote behaviors are applied in the order they are presented on the command-line." + "\n\n" + "Semantic space files stored in one of four formats: text, sparse_text, binary\nsparse_binary.  The sparse versions should be used if the algorithm produces\nsemantic vectors in which more than half of the values are 0.  The sparse\nversions are much more compact for these types of semantic spaces and will be\nboth faster to read and write as well as be much smaller on disk.  Text formats\nare human readable but may take up more space.  Binary formats offer\nsignificantly better I/O performance." + "\n\n" + "Send bug reports or comments to <s-space-research-dev@googlegroups.com>.");
    }

    protected void verbose(String string) {
        LOGGER.fine(string);
    }

    protected void verbose(String string, Object ... objectArray) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format(string, objectArray));
        }
    }
}

