/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.SemanticSpaceIO;
import edu.ucla.sspace.dependency.DefaultDependencyPermutationFunction;
import edu.ucla.sspace.dependency.DependencyPermutationFunction;
import edu.ucla.sspace.dri.DependencyRandomIndexing;
import edu.ucla.sspace.index.PermutationFunction;
import edu.ucla.sspace.index.TernaryPermutationFunction;
import edu.ucla.sspace.mains.DependencyGenericMain;
import edu.ucla.sspace.util.GeneratorMap;
import edu.ucla.sspace.util.SerializableUtil;
import edu.ucla.sspace.vector.TernaryVector;
import java.io.File;
import java.lang.reflect.Constructor;

public class DependencyRandomIndexingMain
extends DependencyGenericMain {
    private DependencyRandomIndexing dri;

    @Override
    public void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('l', "vectorLength", "The size of the vectors", true, "INT", "Process Properties");
        argOptions.addOption('s', "windowSize", "The maximum number of link in a dependency path to accept", true, "INT", "Process Properties");
        argOptions.addOption('P', "usePermutations", "Set if permutations should be used", false, null, "Process Properties");
        argOptions.addOption('p', "permutationFunction", "The DependencyPermutationFunction to use.", true, "CLASSNAME", "Process Properties");
        argOptions.addOption('a', "pathAcceptor", "The DependencyPathAcceptor to use", true, "CLASSNAME", "Optional");
        argOptions.addOption('W', "pathWeighter", "The DependencyPathWeight to use", true, "CLASSNAME", "Optional");
        argOptions.addOption('S', "saveIndexes", "Save index vectors and permutation function to a binary file", true, "FILE", "Post Processing");
        argOptions.addOption('L', "loadIndexes", "Load index vectors and permutation function from binary files", true, "FILE", "Pre Processing");
    }

    private DependencyPermutationFunction getPermutationFunction() {
        try {
            if (!this.argOptions.hasOption('P')) {
                return null;
            }
            if (!this.argOptions.hasOption('p')) {
                return new DefaultDependencyPermutationFunction<TernaryVector>(new TernaryPermutationFunction());
            }
            Class<?> clazz = Class.forName(this.argOptions.getStringOption('p'));
            Constructor<?> constructor = clazz.getConstructor(PermutationFunction.class);
            return (DependencyPermutationFunction)constructor.newInstance(new TernaryPermutationFunction());
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Override
    protected void handleExtraOptions() {
        if (this.argOptions.hasOption("vectorLength")) {
            System.setProperty("edu.ucla.sspace.dri.DependencyRandomIndexing.indexVectorLength", this.argOptions.getStringOption("vectorLength"));
        }
        if (this.argOptions.hasOption("windowSize")) {
            System.setProperty("edu.ucla.sspace.dri.DependencyRandomIndexing.dependencyPathLength", this.argOptions.getStringOption("windowSize"));
        }
        if (this.argOptions.hasOption("pathAcceptor")) {
            System.setProperty("edu.ucla.sspace.dri.DependencyRandomIndexing.dependencyAcceptor", this.argOptions.getStringOption("pathAcceptor"));
        }
        DependencyPermutationFunction dependencyPermutationFunction = null;
        dependencyPermutationFunction = this.argOptions.hasOption("loadIndexes") && this.argOptions.hasOption("usePermutations") ? (DependencyPermutationFunction)SerializableUtil.load(new File(this.argOptions.getStringOption("loadIndexes") + ".permutation")) : this.getPermutationFunction();
        this.setupDependencyExtractor();
        this.dri = new DependencyRandomIndexing(dependencyPermutationFunction, System.getProperties());
        if (this.argOptions.hasOption("loadIndexes")) {
            String string = this.argOptions.getStringOption("loadIndexes");
            this.dri.setWordToVectorMap(SerializableUtil.load(new File(string + ".index"), GeneratorMap.class));
        }
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption("saveIndexes")) {
            String string = this.argOptions.getStringOption("saveIndexes");
            SerializableUtil.save(this.dri.getWordToVectorMap(), new File(string + ".index"));
            SerializableUtil.save(this.dri.getPermutations(), new File(string + ".permutation"));
        }
    }

    @Override
    public SemanticSpace getSpace() {
        return this.dri;
    }

    public static void main(String[] stringArray) {
        DependencyRandomIndexingMain dependencyRandomIndexingMain = new DependencyRandomIndexingMain();
        try {
            dependencyRandomIndexingMain.run(stringArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    protected SemanticSpaceIO.SSpaceFormat getSpaceFormat() {
        return SemanticSpaceIO.SSpaceFormat.SPARSE_BINARY;
    }
}

