/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.mains;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.ArgOptions;
import edu.ucla.sspace.mains.DVWordsiMain;
import edu.ucla.sspace.wordsi.DependencyContextGenerator;
import edu.ucla.sspace.wordsi.OccurrenceDependencyContextGenerator;
import edu.ucla.sspace.wordsi.OrderingDependencyContextGenerator;
import edu.ucla.sspace.wordsi.PartOfSpeechDependencyContextGenerator;

public class DVWCWordsiMain
extends DVWordsiMain {
    private BasisMapping<String, String> basis;

    public static void main(String[] stringArray) throws Exception {
        DVWCWordsiMain dVWCWordsiMain = new DVWCWordsiMain();
        dVWCWordsiMain.run(stringArray);
    }

    @Override
    protected void addExtraOptions(ArgOptions argOptions) {
        super.addExtraOptions(argOptions);
        argOptions.addOption('H', "usePartsOfSpeech", "If provided, parts of speech will be used as part of the word occurrence features.", false, null, "Optional");
        argOptions.addOption('O', "useWordOrdering", "If provided, parts of speech will be used as part of the word occurrence features.", false, null, "Optional");
    }

    @Override
    protected void handleExtraOptions() {
        this.basis = this.argOptions.hasOption('L') ? (BasisMapping)this.loadObject(this.openLoadFile()) : new StringBasisMapping();
    }

    @Override
    protected void postProcessing() {
        if (this.argOptions.hasOption('S')) {
            this.saveObject(this.openSaveFile(), this.basis);
        }
    }

    @Override
    protected DependencyContextGenerator getContextGenerator() {
        if (this.argOptions.hasOption('H')) {
            return new PartOfSpeechDependencyContextGenerator(this.basis, this.windowSize());
        }
        if (this.argOptions.hasOption('O')) {
            return new OrderingDependencyContextGenerator(this.basis, this.windowSize());
        }
        return new OccurrenceDependencyContextGenerator(this.basis, this.windowSize());
    }
}

