/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.lsa;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.common.GenericTermDocumentVectorSpace;
import edu.ucla.sspace.matrix.LogEntropyTransform;
import edu.ucla.sspace.matrix.Matrices;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.SVD;
import edu.ucla.sspace.matrix.Transform;
import edu.ucla.sspace.util.LoggerUtil;
import edu.ucla.sspace.util.ReflectionUtil;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.IOError;
import java.io.IOException;
import java.util.Properties;

public class LatentSemanticAnalysis
extends GenericTermDocumentVectorSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.lsa.LatentSemanticAnalysis";
    public static final String MATRIX_TRANSFORM_PROPERTY = "edu.ucla.sspace.lsa.LatentSemanticAnalysis.transform";
    public static final String LSA_DIMENSIONS_PROPERTY = "edu.ucla.sspace.lsa.LatentSemanticAnalysis.dimensions";
    public static final String LSA_SVD_ALGORITHM_PROPERTY = "edu.ucla.sspace.lsa.LatentSemanticAnalysis.svd.algorithm";
    public static final String RETAIN_DOCUMENT_SPACE_PROPERTY = "edu.ucla.sspace.lsa.LatentSemanticAnalysis.retainDocSpace";
    private static final String LSA_SSPACE_NAME = "lsa-semantic-space";
    private Matrix documentSpace;

    public LatentSemanticAnalysis() throws IOException {
        this.documentSpace = null;
    }

    public LatentSemanticAnalysis(boolean bl, BasisMapping<String, String> basisMapping, MatrixBuilder matrixBuilder) throws IOException {
        super(bl, basisMapping, matrixBuilder);
    }

    @Override
    public String getSpaceName() {
        return LSA_SSPACE_NAME;
    }

    public DoubleVector getDocumentVector(int n) {
        if (this.documentSpace == null) {
            throw new IllegalArgumentException("The document space has not been retained or generated.");
        }
        if (n < 0 || n >= this.documentSpace.rows()) {
            throw new IllegalArgumentException("Document number is not within the bounds of the number of documents: " + n);
        }
        return this.documentSpace.getRowVector(n);
    }

    @Override
    public void processSpace(Properties properties) {
        String string;
        Transform transform = new LogEntropyTransform();
        String string2 = properties.getProperty(MATRIX_TRANSFORM_PROPERTY);
        if (string2 != null) {
            transform = (Transform)ReflectionUtil.getObjectInstance(string2);
        }
        int n = 300;
        String string3 = properties.getProperty(LSA_DIMENSIONS_PROPERTY);
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.lsa.LatentSemanticAnalysis.dimensions is not an integer: " + string3);
            }
        }
        boolean bl = false;
        String string4 = properties.getProperty(RETAIN_DOCUMENT_SPACE_PROPERTY);
        if (string4 != null) {
            bl = Boolean.parseBoolean(string4);
        }
        SVD.Algorithm algorithm = (string = properties.getProperty(LSA_SVD_ALGORITHM_PROPERTY)) == null ? SVD.Algorithm.ANY : SVD.Algorithm.valueOf(string);
        try {
            int n2;
            int n3;
            MatrixFile matrixFile = this.processSpace(transform);
            LoggerUtil.info(LOG, "reducing to %d dimensions", n);
            Matrix[] matrixArray = SVD.svd(matrixFile.getFile(), algorithm, matrixFile.getFormat(), n);
            this.wordSpace = matrixArray[0];
            Matrix matrix = matrixArray[1];
            for (n3 = 0; n3 < this.wordSpace.rows(); ++n3) {
                for (n2 = 0; n2 < this.wordSpace.columns(); ++n2) {
                    this.wordSpace.set(n3, n2, this.wordSpace.get(n3, n2) * matrix.get(n2, n2));
                }
            }
            if (bl) {
                LoggerUtil.verbose(LOG, "loading in document space", new Object[0]);
                this.documentSpace = Matrices.transpose(matrixArray[2]);
                for (n3 = 0; n3 < this.documentSpace.rows(); ++n3) {
                    for (n2 = 0; n2 < this.documentSpace.columns(); ++n2) {
                        this.documentSpace.set(n3, n2, this.documentSpace.get(n3, n2) * matrix.get(n2, n2));
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

