/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.index;

import edu.ucla.sspace.index.DoubleVectorGenerator;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;

public class RandomOrthogonalVectorGenerator
implements DoubleVectorGenerator<DoubleVector>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Random RANDOM = new Random();
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.index.RandomOrthogonalVectorGenerator";
    public static final String VECTOR_MEAN_PROPERTY = "edu.ucla.sspace.index.RandomOrthogonalVectorGenerator.mean";
    public static final String VECTOR_STANDARD_DEVIATION_PROPERTY = "edu.ucla.sspace.index.RandomOrthogonalVectorGenerator.std";
    public static final String VECTOR_LENGTH_PROPERTY = "edu.ucla.sspace.index.RandomOrthogonalVectorGenerator.length";
    public static final int DEFAULT_VECTOR_MEAN = 0;
    public static final int DEFAULT_VECTOR_LENGTH = 1000;
    public static final int DEFAULT_VECTOR_STANDARD_DEVIATION = 1;
    private double mean;
    private double std;
    private int vectorLength;
    private final List<DoubleVector> generatedVectors;

    public RandomOrthogonalVectorGenerator(int n) {
        this(n, System.getProperties(), null);
    }

    public RandomOrthogonalVectorGenerator(int n, DoubleVector doubleVector) {
        this(n, System.getProperties(), doubleVector);
    }

    public RandomOrthogonalVectorGenerator(int n, Properties properties, DoubleVector doubleVector) {
        String string = properties.getProperty(VECTOR_MEAN_PROPERTY);
        this.mean = string != null ? Double.parseDouble(string) : 0.0;
        String string2 = properties.getProperty(VECTOR_STANDARD_DEVIATION_PROPERTY);
        this.std = string2 != null ? Double.parseDouble(string2) : 1.0;
        this.vectorLength = n;
        this.generatedVectors = new ArrayList<DoubleVector>();
        if (doubleVector == null) {
            doubleVector = RandomOrthogonalVectorGenerator.generateInitialVector(n, this.mean, this.std);
        }
        this.generatedVectors.add(doubleVector);
    }

    private static DoubleVector generateInitialVector(int n, double d, double d2) {
        DenseVector denseVector = new DenseVector(n);
        for (int i = 0; i < n; ++i) {
            double d3 = RANDOM.nextGaussian();
            d3 = d2 * d3 + d;
            denseVector.set(i, d3);
        }
        return denseVector;
    }

    private static double dotProduct(DoubleVector doubleVector, DoubleVector doubleVector2) {
        double d = 0.0;
        for (int i = 0; i < doubleVector.length(); ++i) {
            double d2 = doubleVector.get(i);
            double d3 = doubleVector2.get(i);
            d += doubleVector.get(i) * doubleVector2.get(i);
        }
        return d;
    }

    @Override
    public DoubleVector generate() {
        if (this.generatedVectors.size() == this.vectorLength) {
            throw new IllegalArgumentException("Too many vectors have been generated");
        }
        DoubleVector doubleVector = RandomOrthogonalVectorGenerator.generateInitialVector(this.vectorLength, this.mean, this.std);
        for (DoubleVector doubleVector2 : this.generatedVectors) {
            double d = RandomOrthogonalVectorGenerator.dotProduct(doubleVector2, doubleVector);
            double d2 = RandomOrthogonalVectorGenerator.dotProduct(doubleVector2, doubleVector2);
            for (int i = 0; i < this.vectorLength; ++i) {
                double d3 = doubleVector2.get(i) * d / d2;
                doubleVector.set(i, doubleVector.get(i) - d3);
            }
        }
        this.generatedVectors.add(doubleVector);
        return doubleVector;
    }
}

