/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.index;

import edu.ucla.sspace.index.DoubleVectorGenerator;
import edu.ucla.sspace.vector.DenseVector;
import edu.ucla.sspace.vector.DoubleVector;
import java.io.Serializable;
import java.util.Properties;
import java.util.Random;

public class GaussianVectorGenerator
implements DoubleVectorGenerator<DoubleVector>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.index.GuassianVectorGenerator";
    public static final String STANDARD_DEVIATION_PROPERTY = "edu.ucla.sspace.index.GuassianVectorGenerator.stdev";
    public static final String MEAN_PROPERTY = "edu.ucla.sspace.index.GuassianVectorGenerator.mean";
    public static final double DEFAULT_STANDARD_DEVIATION = 1.0;
    public static final String DEFAULT_MEAN = "0";
    private double stdev;
    private final int indexVectorLength;
    private double mean;
    private Random randomGenerator = new Random();

    public GaussianVectorGenerator(int n) {
        this(n, System.getProperties());
    }

    public GaussianVectorGenerator(int n, Properties properties) {
        this.indexVectorLength = n;
        String string = properties.getProperty(STANDARD_DEVIATION_PROPERTY);
        this.stdev = string != null ? Double.parseDouble(string) : 1.0;
        this.mean = Double.parseDouble(properties.getProperty(MEAN_PROPERTY, DEFAULT_MEAN));
    }

    @Override
    public synchronized DoubleVector generate() {
        DenseVector denseVector = new DenseVector(this.indexVectorLength);
        for (int i = 0; i < this.indexVectorLength; ++i) {
            denseVector.set(i, this.mean + this.randomGenerator.nextGaussian() * this.stdev);
        }
        return denseVector;
    }
}

