/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.hal;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Statistics;
import edu.ucla.sspace.hal.ConcatenatedSparseDoubleVector;
import edu.ucla.sspace.hal.LinearWeighting;
import edu.ucla.sspace.hal.WeightingFunction;
import edu.ucla.sspace.matrix.AtomicGrowingSparseHashMatrix;
import edu.ucla.sspace.matrix.Matrix;
import edu.ucla.sspace.matrix.YaleSparseMatrix;
import edu.ucla.sspace.text.IteratorFactory;
import edu.ucla.sspace.util.BoundedSortedMultiMap;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.CompactSparseVector;
import edu.ucla.sspace.vector.SparseDoubleVector;
import edu.ucla.sspace.vector.Vector;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class HyperspaceAnalogueToLanguage
implements SemanticSpace {
    private static final String PROPERTY_PREFIX = "edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage";
    public static final String ENTROPY_THRESHOLD_PROPERTY = "edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.threshold";
    public static final String WINDOW_SIZE_PROPERTY = "edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.windowSize";
    public static final String RETAIN_PROPERTY = "edu.ucla.sspace.hal.retainColumns";
    public static final String WEIGHTING_FUNCTION_PROPERTY = "edu.ucla.sspace.hal.weighting";
    public static final int DEFAULT_WINDOW_SIZE = 5;
    public static final WeightingFunction DEFAULT_WEIGHTING = new LinearWeighting();
    private static final Logger LOGGER = Logger.getLogger(HyperspaceAnalogueToLanguage.class.getName());
    private final Map<String, Integer> termToIndex;
    private final int windowSize;
    private final WeightingFunction weighting;
    private int wordIndexCounter = 0;
    private AtomicGrowingSparseHashMatrix cooccurrenceMatrix = new AtomicGrowingSparseHashMatrix();
    private Matrix reduced = null;

    public HyperspaceAnalogueToLanguage() {
        this(System.getProperties());
    }

    public HyperspaceAnalogueToLanguage(Properties properties) {
        this.termToIndex = new ConcurrentHashMap<String, Integer>();
        String string = properties.getProperty(WINDOW_SIZE_PROPERTY);
        this.windowSize = string != null ? Integer.parseInt(string) : 5;
        String string2 = properties.getProperty(WEIGHTING_FUNCTION_PROPERTY);
        this.weighting = string2 == null ? DEFAULT_WEIGHTING : HyperspaceAnalogueToLanguage.loadWeightingFunction(string2);
    }

    private static WeightingFunction loadWeightingFunction(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            WeightingFunction weightingFunction = (WeightingFunction)clazz.newInstance();
            return weightingFunction;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Override
    public void processDocument(BufferedReader bufferedReader) throws IOException {
        int n;
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque<String> arrayDeque2 = new ArrayDeque<String>();
        Iterator<String> iterator = IteratorFactory.tokenizeOrdered(bufferedReader);
        String string = null;
        HashMap<Pair<Integer>, Double> hashMap = new HashMap<Pair<Integer>, Double>();
        for (n = 0; n < this.windowSize && iterator.hasNext(); ++n) {
            arrayDeque.offer(iterator.next());
        }
        while (!arrayDeque.isEmpty()) {
            Double d;
            double d2;
            Pair<Integer> pair;
            int n2;
            string = (String)arrayDeque.remove();
            if (iterator.hasNext()) {
                String string2 = iterator.next();
                arrayDeque.offer(string2);
            }
            if (string.equals("")) {
                arrayDeque2.offer(string);
                if (arrayDeque2.size() <= this.windowSize) continue;
                arrayDeque2.remove();
                continue;
            }
            n = this.getIndexFor(string);
            int n3 = 1;
            for (String string3 : arrayDeque) {
                if (!string3.equals("")) {
                    n2 = this.getIndexFor(string3);
                    pair = new Pair<Integer>(n, n2);
                    d2 = this.weighting.weight(n3, this.windowSize);
                    d = (Double)hashMap.get(pair);
                    hashMap.put(pair, d == null ? d2 : d2 + d);
                }
                ++n3;
            }
            n3 = -1;
            for (String string3 : arrayDeque2) {
                if (!string3.equals("")) {
                    n2 = this.getIndexFor(string3);
                    pair = new Pair<Integer>(n2, n);
                    d2 = this.weighting.weight(n3, this.windowSize);
                    d = (Double)hashMap.get(pair);
                    hashMap.put(pair, d == null ? d2 : d2 + d);
                }
                --n3;
            }
            arrayDeque2.offer(string);
            if (arrayDeque2.size() <= this.windowSize) continue;
            arrayDeque2.remove();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Iterator iterator2 = (Pair)entry.getKey();
            this.cooccurrenceMatrix.addAndGet((Integer)((Pair)((Object)iterator2)).x, (Integer)((Pair)((Object)iterator2)).y, (Double)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getIndexFor(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            HyperspaceAnalogueToLanguage hyperspaceAnalogueToLanguage = this;
            synchronized (hyperspaceAnalogueToLanguage) {
                n = this.termToIndex.get(string);
                if (n == null) {
                    int n2 = this.wordIndexCounter++;
                    this.termToIndex.put(string, n2);
                    return n2;
                }
            }
        }
        return n;
    }

    @Override
    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.termToIndex.keySet());
    }

    @Override
    public Vector getVector(String string) {
        Integer n = this.termToIndex.get(string);
        if (n == null) {
            return null;
        }
        if (this.reduced == null) {
            SparseDoubleVector sparseDoubleVector = n < this.cooccurrenceMatrix.rows() ? this.cooccurrenceMatrix.getRowVectorUnsafe(n) : new CompactSparseVector(this.termToIndex.size());
            SparseDoubleVector sparseDoubleVector2 = n < this.cooccurrenceMatrix.columns() ? this.cooccurrenceMatrix.getColumnVectorUnsafe(n) : new CompactSparseVector(this.termToIndex.size());
            return new ConcatenatedSparseDoubleVector(sparseDoubleVector, sparseDoubleVector2);
        }
        return this.reduced.getRowVector(n);
    }

    @Override
    public int getVectorLength() {
        if (this.cooccurrenceMatrix != null) {
            return this.cooccurrenceMatrix.columns() + this.cooccurrenceMatrix.rows();
        }
        return this.reduced.columns();
    }

    private double[] getColumn(int n) {
        int n2 = this.cooccurrenceMatrix.rows();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.cooccurrenceMatrix.get(i, n);
        }
        return dArray;
    }

    @Override
    public void processSpace(Properties properties) {
        String string = properties.getProperty(ENTROPY_THRESHOLD_PROPERTY);
        String string2 = properties.getProperty(RETAIN_PROPERTY);
        if (string != null && string2 != null) {
            throw new IllegalArgumentException("Cannot define the edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.threshold and edu.ucla.sspace.hal.retainColumns properties at the same time");
        }
        if (string != null) {
            try {
                double d = Double.parseDouble(string);
                this.thresholdColumns(d);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.hal.HyperspaceAnalogueToLanguage.threshold is not an number: " + string);
            }
        } else if (string2 != null) {
            try {
                int n = Integer.parseInt(string2);
                this.retainOnly(n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("edu.ucla.sspace.hal.retainColumns is not an number: " + string2);
            }
        } else {
            return;
        }
    }

    private void retainOnly(int n) {
        int n2;
        int n3 = this.termToIndex.size();
        BoundedSortedMultiMap<Double, Integer> boundedSortedMultiMap = new BoundedSortedMultiMap<Double, Integer>(n, false, true, true);
        for (n2 = 0; n2 < n3; ++n2) {
            boundedSortedMultiMap.put(Statistics.entropy(this.getColumn(n2)), n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double[] dArray = this.cooccurrenceMatrix.getRow(n2);
            boundedSortedMultiMap.put(Statistics.entropy(dArray), n2 + n3);
        }
        LOGGER.info("reducing to " + n + " columns");
        this.reduced = new YaleSparseMatrix(n3, n);
        HashSet hashSet = new HashSet(boundedSortedMultiMap.values());
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < n3 * 2; ++j) {
                if (!hashSet.contains(j)) continue;
                if (j < n3) {
                    this.reduced.set(i, n4, this.cooccurrenceMatrix.get(i, j));
                } else {
                    this.reduced.set(i, n4, this.cooccurrenceMatrix.get(j - n3, i));
                }
                ++n4;
            }
        }
        this.cooccurrenceMatrix = null;
    }

    private void thresholdColumns(double d) {
        double d2;
        double[] dArray;
        int n;
        int n2 = this.termToIndex.size();
        BitSet bitSet = new BitSet(n2 * 2);
        for (n = 0; n < n2; ++n) {
            dArray = this.getColumn(n);
            d2 = Statistics.entropy(dArray);
            if (!(d2 < d)) continue;
            bitSet.set(n);
        }
        for (n = 0; n < n2; ++n) {
            dArray = this.cooccurrenceMatrix.getRow(n);
            d2 = Statistics.entropy(dArray);
            if (!(d2 < d)) continue;
            bitSet.set(n + n2);
        }
        LOGGER.info("dropping " + bitSet.cardinality() + "/" + n2 * 2 + " columns, which were below the threshold of " + d);
        this.reduced = new YaleSparseMatrix(n2, n2 * 2 - bitSet.cardinality());
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            for (int i = 0; i < n2 * 2; ++i) {
                if (bitSet.get(i)) continue;
                if (i < n2) {
                    this.reduced.set(n, n3, this.cooccurrenceMatrix.get(n, i));
                } else {
                    this.reduced.set(n, n3, this.cooccurrenceMatrix.get(i - n2, n));
                }
                ++n3;
            }
        }
        this.cooccurrenceMatrix = null;
    }

    @Override
    public String getSpaceName() {
        return "hal-semantic-space";
    }
}

