/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.AbstractWordPrimingTest;
import edu.ucla.sspace.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class OnePairPerLinePrimingTest
extends AbstractWordPrimingTest {
    private final String dataFileName;

    public OnePairPerLinePrimingTest(String string) {
        this(new File(string));
    }

    public OnePairPerLinePrimingTest(File file) {
        super(OnePairPerLinePrimingTest.prepareRelationMap(file));
        this.dataFileName = file.getName();
    }

    public static Set<Pair<String>> prepareRelationMap(File file) {
        HashSet<Pair<String>> hashSet = new HashSet<Pair<String>>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() == 0 || string.startsWith("#")) continue;
                String[] stringArray = string.split("\\s+");
                hashSet.add(new Pair<String>(stringArray[0], stringArray[1]));
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return hashSet;
    }

    @Override
    protected Double computePriming(SemanticSpace semanticSpace, String string, String string2) {
        return Similarity.cosineSimilarity(semanticSpace.getVector(string), semanticSpace.getVector(string2));
    }

    public String toString() {
        return "Priming Relation: " + this.dataFileName;
    }
}

