/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.evaluation.SimpleWordSimilarity;
import edu.ucla.sspace.evaluation.WordSimilarity;
import edu.ucla.sspace.evaluation.WordSimilarityEvaluation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class FinkelsteinEtAl353WordSimilarityEvaluation
implements WordSimilarityEvaluation {
    private final Collection<WordSimilarity> pairs;
    private final String dataFileName;

    public FinkelsteinEtAl353WordSimilarityEvaluation(String string) {
        this(new File(string));
    }

    public FinkelsteinEtAl353WordSimilarityEvaluation(File file) {
        this.pairs = this.parse(file);
        this.dataFileName = file.getName();
    }

    private Collection<WordSimilarity> parse(File file) {
        String string = file.getName().endsWith(".csv") ? "," : "\\s";
        LinkedList<WordSimilarity> linkedList = new LinkedList<WordSimilarity>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            bufferedReader.readLine();
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(string);
                if (stringArray.length != 3) {
                    throw new Error("Unexpected line formatting: " + string2);
                }
                linkedList.add(new SimpleWordSimilarity(stringArray[0], stringArray[1], Double.parseDouble(stringArray[2])));
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
        return linkedList;
    }

    @Override
    public Collection<WordSimilarity> getPairs() {
        return this.pairs;
    }

    @Override
    public double getMostSimilarValue() {
        return 10.0;
    }

    @Override
    public double getLeastSimilarValue() {
        return 0.0;
    }

    public String toString() {
        return "Finkelstein et al. Word Similarity Test [" + this.dataFileName + "]";
    }
}

