/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.AbstractWordAssociationTest;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.vector.Vector;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class DeeseAntonymEvaluation
extends AbstractWordAssociationTest {
    private static final Set<Pair<String>> DEESE_ANTONYMS = new LinkedHashSet<Pair<String>>();

    public DeeseAntonymEvaluation() {
        super(DeeseAntonymEvaluation.createMap());
    }

    private static Map<Pair<String>, Double> createMap() {
        HashMap<Pair<String>, Double> hashMap = new HashMap<Pair<String>, Double>();
        for (Pair<String> pair : DEESE_ANTONYMS) {
            hashMap.put(pair, 1.0);
        }
        return hashMap;
    }

    @Override
    protected double getLowestScore() {
        return 0.0;
    }

    @Override
    protected double getHighestScore() {
        return 1.0;
    }

    @Override
    protected Double computeAssociation(SemanticSpace semanticSpace, String string, String string2) {
        Vector vector = semanticSpace.getVector(string);
        Vector vector2 = semanticSpace.getVector(string2);
        if (vector == null || vector2 == null) {
            return null;
        }
        double d = this.findRank(semanticSpace, string, string2);
        double d2 = this.findRank(semanticSpace, string2, string);
        return 2.0 / (d + d2);
    }

    @Override
    protected double computeScore(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (double d2 : dArray2) {
            d += d2;
        }
        return d / (double)dArray2.length;
    }

    private int findRank(SemanticSpace semanticSpace, String string, String string2) {
        Vector vector = semanticSpace.getVector(string);
        Vector vector2 = semanticSpace.getVector(string2);
        double d = Similarity.cosineSimilarity(vector, vector2);
        int n = 0;
        for (String string3 : semanticSpace.getWords()) {
            Vector vector3 = semanticSpace.getVector(string3);
            double d2 = Similarity.cosineSimilarity(vector, vector3);
            if (!(d2 > d)) continue;
            ++n;
        }
        return n;
    }

    static {
        DEESE_ANTONYMS.add(new Pair<String>("active", "passive"));
        DEESE_ANTONYMS.add(new Pair<String>("bad", "good"));
        DEESE_ANTONYMS.add(new Pair<String>("high", "low"));
        DEESE_ANTONYMS.add(new Pair<String>("right", "wrong"));
        DEESE_ANTONYMS.add(new Pair<String>("big", "little"));
        DEESE_ANTONYMS.add(new Pair<String>("empty", "full"));
        DEESE_ANTONYMS.add(new Pair<String>("narrow", "wide"));
        DEESE_ANTONYMS.add(new Pair<String>("strong", "weak"));
        DEESE_ANTONYMS.add(new Pair<String>("cold", "hot"));
        DEESE_ANTONYMS.add(new Pair<String>("heavy", "light"));
        DEESE_ANTONYMS.add(new Pair<String>("pretty", "ugly"));
        DEESE_ANTONYMS.add(new Pair<String>("alone", "together"));
        DEESE_ANTONYMS.add(new Pair<String>("few", "many"));
        DEESE_ANTONYMS.add(new Pair<String>("dark", "light"));
        DEESE_ANTONYMS.add(new Pair<String>("bottom", "top"));
        DEESE_ANTONYMS.add(new Pair<String>("long", "short"));
        DEESE_ANTONYMS.add(new Pair<String>("sour", "sweet"));
        DEESE_ANTONYMS.add(new Pair<String>("clean", "dirty"));
        DEESE_ANTONYMS.add(new Pair<String>("hard", "soft"));
        DEESE_ANTONYMS.add(new Pair<String>("rich", "poor"));
        DEESE_ANTONYMS.add(new Pair<String>("back", "front"));
        DEESE_ANTONYMS.add(new Pair<String>("dry", "wet"));
        DEESE_ANTONYMS.add(new Pair<String>("left", "right"));
        DEESE_ANTONYMS.add(new Pair<String>("short", "tall"));
        DEESE_ANTONYMS.add(new Pair<String>("far", "near"));
        DEESE_ANTONYMS.add(new Pair<String>("easy", "hard"));
        DEESE_ANTONYMS.add(new Pair<String>("happy", "sad"));
        DEESE_ANTONYMS.add(new Pair<String>("old", "young"));
        DEESE_ANTONYMS.add(new Pair<String>("alive", "dead"));
        DEESE_ANTONYMS.add(new Pair<String>("deep", "shallow"));
        DEESE_ANTONYMS.add(new Pair<String>("large", "small"));
        DEESE_ANTONYMS.add(new Pair<String>("rough", "smooth"));
        DEESE_ANTONYMS.add(new Pair<String>("black", "white"));
        DEESE_ANTONYMS.add(new Pair<String>("fast", "slow"));
        DEESE_ANTONYMS.add(new Pair<String>("new", "old"));
        DEESE_ANTONYMS.add(new Pair<String>("thin", "thick"));
        DEESE_ANTONYMS.add(new Pair<String>("first", "last"));
        DEESE_ANTONYMS.add(new Pair<String>("single", "married"));
        DEESE_ANTONYMS.add(new Pair<String>("inside", "outside"));
    }
}

