/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.evaluation;

import edu.ucla.sspace.common.SemanticSpace;
import edu.ucla.sspace.common.Similarity;
import edu.ucla.sspace.evaluation.SimpleWordAssociationReport;
import edu.ucla.sspace.evaluation.WordAssociationReport;
import edu.ucla.sspace.evaluation.WordAssociationTest;
import edu.ucla.sspace.util.Pair;
import edu.ucla.sspace.util.WorkerThread;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractWordAssociationTest
implements WordAssociationTest {
    protected final Map<Pair<String>, Double> wordPairToHumanJudgement;

    public AbstractWordAssociationTest(Map<Pair<String>, Double> map) {
        this.wordPairToHumanJudgement = map;
    }

    @Override
    public WordAssociationReport evaluate(final SemanticSpace semanticSpace) {
        int n;
        int n2 = Runtime.getRuntime().availableProcessors();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        for (int i = 0; i < n2; ++i) {
            WorkerThread workerThread = new WorkerThread(linkedBlockingQueue);
            workerThread.start();
        }
        final Semaphore semaphore = new Semaphore(0);
        final double d = this.getHighestScore() - this.getLowestScore();
        final AtomicInteger atomicInteger = new AtomicInteger();
        final AtomicInteger atomicInteger2 = new AtomicInteger();
        int n3 = this.wordPairToHumanJudgement.size();
        final double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        for (Map.Entry<Pair<String>, Double> object2 : this.wordPairToHumanJudgement.entrySet()) {
            double d2;
            final Pair<String> i = object2.getKey();
            n = n4++;
            dArray2[n] = d2 = object2.getValue().doubleValue();
            linkedBlockingQueue.offer(new Runnable(){

                @Override
                public void run() {
                    Double d2 = AbstractWordAssociationTest.this.computeAssociation(semanticSpace, (String)i.x, (String)i.y);
                    if (d2 == null) {
                        atomicInteger.incrementAndGet();
                        dArray[n] = Double.MIN_VALUE;
                    } else {
                        atomicInteger2.incrementAndGet();
                        dArray[n] = d2 * d + AbstractWordAssociationTest.this.getLowestScore();
                    }
                    semaphore.release();
                }
            });
        }
        try {
            semaphore.acquire(n3);
        }
        catch (InterruptedException interruptedException) {
            throw new Error(interruptedException);
        }
        Object object3 = new double[atomicInteger2.get()];
        double[] dArray3 = new double[atomicInteger2.get()];
        n = 0;
        for (int d3 = 0; d3 < n3; ++d3) {
            if (dArray[d3] == Double.MIN_VALUE) continue;
            object3[n] = dArray2[d3];
            dArray3[n] = dArray[d3];
            ++n;
        }
        double d3 = this.computeScore(dArray2, dArray);
        return new SimpleWordAssociationReport(this.wordPairToHumanJudgement.size(), d3, atomicInteger.get());
    }

    protected double computeScore(double[] dArray, double[] dArray2) {
        return Similarity.correlation(dArray, dArray2);
    }

    protected abstract double getLowestScore();

    protected abstract double getHighestScore();

    protected abstract Double computeAssociation(SemanticSpace var1, String var2, String var3);
}

