/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.esa;

import edu.ucla.sspace.basis.BasisMapping;
import edu.ucla.sspace.basis.StringBasisMapping;
import edu.ucla.sspace.common.GenericTermDocumentVectorSpace;
import edu.ucla.sspace.matrix.MatrixBuilder;
import edu.ucla.sspace.matrix.MatrixFile;
import edu.ucla.sspace.matrix.MatrixIO;
import edu.ucla.sspace.matrix.SvdlibcSparseBinaryMatrixBuilder;
import edu.ucla.sspace.matrix.TfIdfTransform;
import edu.ucla.sspace.util.GrowableArrayList;
import edu.ucla.sspace.util.SparseArray;
import edu.ucla.sspace.util.SparseHashArray;
import edu.ucla.sspace.vector.SparseVector;
import edu.ucla.sspace.vector.Vector;
import java.io.IOError;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ExplicitSemanticAnalysis
extends GenericTermDocumentVectorSpace {
    public static final String ESA_SSPACE_NAME = "esa-semantic-space";
    private final List<String> documentLabels = Collections.synchronizedList(new GrowableArrayList());

    public ExplicitSemanticAnalysis() throws IOException {
        super(true, new StringBasisMapping(), new SvdlibcSparseBinaryMatrixBuilder());
    }

    public ExplicitSemanticAnalysis(BasisMapping<String, String> basisMapping, MatrixBuilder matrixBuilder) throws IOException {
        super(true, basisMapping, matrixBuilder);
    }

    @Override
    protected void handleDocumentHeader(int n, String string) {
        this.documentLabels.set(n, string);
    }

    public SparseArray<String> getDocumentDescriptors(Vector vector) {
        if (vector.length() != this.getVectorLength()) {
            throw new IllegalArgumentException("An documentVector with an invalid length cannot be interpreted by ESA.");
        }
        SparseHashArray<String> sparseHashArray = new SparseHashArray<String>();
        if (vector instanceof SparseVector) {
            int[] nArray;
            for (int n : nArray = ((SparseVector)vector).getNonZeroIndices()) {
                sparseHashArray.set(n, this.documentLabels.get(n));
            }
        } else {
            for (int i = 0; i < vector.length(); ++i) {
                if (vector.getValue(i).doubleValue() == 0.0) continue;
                sparseHashArray.set(i, this.documentLabels.get(i));
            }
        }
        return sparseHashArray;
    }

    @Override
    public void processSpace(Properties properties) {
        try {
            MatrixFile matrixFile = this.processSpace(new TfIdfTransform());
            this.wordSpace = MatrixIO.readMatrix(matrixFile.getFile(), matrixFile.getFormat());
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    @Override
    public String getSpaceName() {
        return ESA_SSPACE_NAME;
    }
}

