/*
 * Decompiled with CFR 0.152.
 */
package edu.ucla.sspace.dv;

import edu.ucla.sspace.dependency.DependencyPath;
import edu.ucla.sspace.dependency.DependencyPathAcceptor;
import edu.ucla.sspace.dv.PennTags;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinimumPennTemplateAcceptor
implements DependencyPathAcceptor {
    static final Set<String> MINIMUM_TEMPLATES = new HashSet<String>();
    static final Map<String, String> POS_TAG_TO_CLASS = new HashMap<String, String>();

    @Override
    public boolean accepts(DependencyPath dependencyPath) {
        return MinimumPennTemplateAcceptor.acceptsInternal(dependencyPath);
    }

    static boolean acceptsInternal(DependencyPath dependencyPath) {
        if (dependencyPath.length() != 2) {
            return false;
        }
        if (dependencyPath.getNode(0).word().equals("") || dependencyPath.getNode(0).word().equals("")) {
            return false;
        }
        String string = dependencyPath.getNode(0).pos();
        String string2 = dependencyPath.getRelation(0);
        String string3 = dependencyPath.getNode(1).pos();
        String string4 = POS_TAG_TO_CLASS.get(string);
        String string5 = POS_TAG_TO_CLASS.get(string3);
        String string6 = MinimumPennTemplateAcceptor.toPattern(string4 == null ? string : string4, string2, string5 == null ? string3 : string5);
        return MINIMUM_TEMPLATES.contains(string6);
    }

    @Override
    public int maxPathLength() {
        return 2;
    }

    static String toPattern(String string, String string2, String string3) {
        return string + ":" + string2 + ":" + string3;
    }

    static {
        for (String string : PennTags.NOUN_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "N");
        }
        for (String string : PennTags.ADJ_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "J");
        }
        for (String string : PennTags.ADV_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "R");
        }
        for (String string : PennTags.VERB_POS_TAGS) {
            POS_TAG_TO_CLASS.put(string, "V");
        }
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "VMOD", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "AMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "PROD", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "PMOD", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "ADV", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "ADV", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("R", "ADV", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("J", "NMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("J", "NMOD", "TO"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("J", "PMOD", "TO"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("J", "SBJ", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "COORD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "PROD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "NMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "NMOD", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "NMOD", "TO"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "NMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "OBJ", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "SBJ", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "SBJ", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "SBJ", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "SBJ", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("N", "ADV", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "AMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "NMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "VMOD", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "PMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "ADV", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "ADV", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "ADV", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("TO", "ADV", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "AMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "NMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "VMOD", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "PMOD", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "ADV", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "ADV", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "ADV", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("IN", "ADV", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "AMOD", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "VMOD", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "VMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "AMOD", "J"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "PMOD", "TO"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "OBJ", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "SBJ", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "ADV", "N"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "ADV", "R"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "ADV", "V"));
        MINIMUM_TEMPLATES.add(MinimumPennTemplateAcceptor.toPattern("V", "ADV", "J"));
    }
}

